% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{quantilenorm}
\alias{quantilenorm}
\title{Quantile Normalization of glycan data}
\usage{
quantilenorm(d, grouping = FALSE, transpose = FALSE)
}
\arguments{
\item{d}{data frame in long format containing glycan measurements}

\item{grouping}{should data be normalized per groups}

\item{transpose}{transpose the data prior to normalization}
}
\value{
Returns a data.frame with original glycan values substituted by normalized ones
}
\description{
Returns glycans normalized with Quantile Normalization approach.
}
\details{
Input data frame should have at least the following three columns: \cr
  - gid - representing a unique name of a sample \cr
  - glycan - representing glycan names \cr
  - value - representing measured values \cr
and if the grouping argument is \code{TRUE} it should also have column: \cr
  - groups - representing groupings (e.g. IgG1, IgG2 and IgG4)
}
\examples{
data(mpiu)
if(requireNamespace("preprocessCore", quietly=TRUE)){
  mpiun <- quantilenorm(mpiu)
  head(mpiun)

  # transpose (change) subjects and measurements
  mpiunt <- quantilenorm(mpiu, transpose=TRUE)
  head(mpiunt)
}
}
\references{
Bolstad, B. M., Irizarry R. A., Astrand, M, and Speed, T. P.: \cr
A Comparison of Normalization Methods for High Density Oligonucleotide
Array Data Based on Bias and Variance.\cr
Bioinformatics 19(2), p. 185-193, 2003. \cr
\doi{10.1093/bioinformatics/19.2.185}
}
\author{
Ivo Ugrina, Lucija Klarić
}
