% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si-prefixes.R
\name{SI_pl_format}
\alias{SI_pl_format}
\alias{SI_plain}
\title{Formatter for plain labels discounting for SI multipliers}
\usage{
SI_pl_format(exponent = 0, digits = 3, ...)

SI_plain(x, exponent = 0, digits = 3, ...)
}
\arguments{
\item{exponent}{numeric Power of 10 to use as multiplier}

\item{digits}{number of significant digits to show}

\item{...}{other arguments passed on to \code{\link{format}}}

\item{x}{a numeric vector to format}
}
\value{
a function with single parameter x, a numeric vector, that
  returns a character vector
}
\description{
The labels generated represent numbers rescaled to compensate for a change
in unit's by a factor of ten or by a power of ten.
}
\examples{

SI_pl_format()(1:10)
SI_pl_format()(runif(10))
SI_pl_format(exponent = 2)(runif(10))
SI_plain(1:10)
SI_plain(runif(10))
SI_plain(runif(10), digits = 2)
}
