% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggarrange.R
\name{ggarrange}
\alias{ggarrange}
\title{Arrange Multiple ggplots}
\usage{
ggarrange(..., plotlist = NULL, ncol = NULL, nrow = NULL, labels = NULL)
}
\arguments{
\item{...}{list of plots to be arranged into the grid. The plots can be
either ggplot2 plot objects or arbitrary gtables.}

\item{plotlist}{(optional) list of plots to display.}

\item{ncol}{(optional) number of columns in the plot grid.}

\item{nrow}{(optional) number of rows in the plot grid.}

\item{labels}{(optional) list of labels to be added to the plots. You can
also set labels="AUTO" to auto-generate upper-case labels or labels="auto"
to auto-generate lower-case labels.}
}
\value{
return an object of class \code{ggarrange}, which is a ggplot or a list of ggplot.
}
\description{
Arrange multiple ggplots on the same page. Wrapper around
  \code{\link[cowplot]{plot_grid}}. Can arrange multiple ggplots over
  multiple pages.
}
\examples{
data("ToothGrowth")
df <- ToothGrowth
df$dose <- as.factor(df$dose)

# Box plot
bxp <- ggboxplot(df, x = "dose", y = "len",
    color = "dose", palette = "jco")
# Dot plot
dp <- ggdotplot(df, x = "dose", y = "len",
    color = "dose", palette = "jco")
# Density plot
dens <- ggdensity(df, x = "len", fill = "dose", palette = "jco")

ggarrange(bxp, dp, dens, ncol = 2, nrow = 2)

}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
