% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_data}
\alias{run_data}
\alias{run_data_parallel}
\alias{run_hyper}
\alias{run_hyper_parallel}
\title{Run a Bayesian EAM Model for Fixed-effect or Random-effect}
\usage{
run_data(samples, setting, debug = FALSE)

run_data_parallel(samples, setting, debug = FALSE)

run_hyper(samples, setting)

run_hyper_parallel(samples, setting)
}
\arguments{
\item{samples}{a DMC sample/object}

\item{setting}{a container to store all settings for running model fitting}

\item{debug}{a debugging switch to test chain randomisation. Default false}
}
\value{
a DMC sample
}
\description{
These are the C++ functions hierarchical Bayesian models. The user usually
should not call this function directly. Use \code{h.run.dmc} or
\code{run.dmc} wrapper instead.  Two parallel versions of \code{run} uses
Open MPI to calculate diffusion probability density. Use them by setting
\code{cores} greater than 2 in \code{h.run.dmc}
}

