% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbox_dem.R
\name{mapbox_dem}
\alias{mapbox_dem}
\title{Gets Digital Elevation Model (DEM) data from 'mapbox'}
\usage{
mapbox_dem(lat, long, square_km, width_buffer = 1, max_tiles = 10,
  api_key)
}
\arguments{
\item{lat}{WGS84 latitude. Either a single point to use as the centre for a \code{square_km} sized raster, or a vector of track points}

\item{long}{WGS84 longitude. Either a single point to use as the centre for a \code{square_km} sized raster, or a vector of track points}

\item{square_km}{length of one edge the required square area, in km. Ignored if lat and long have length > 1}

\item{width_buffer}{If lat and long have length > 1, used as buffer distance around the provided points in km}

\item{max_tiles}{maximum number of map tiles to request. More tiles will give higher resolution scenes but take longer to download. Note that very small numbers of tiles may result in a scene that is not square.}

\item{api_key}{'Mapbox' API key}
}
\value{
a raster with values corresponding to terrain height in metres
}
\description{
Gets Digital Elevation Model (DEM) data from 'mapbox'
}
\examples{
\dontrun{
#NOT RUN
#mapbox_dem() requires a 'mapbox' API key

mapbox_key = "YOUR_MAPBOX_API_KEY"

lat = 54.4502651
long = -3.1767946
square_km = 20

dem <- mapbox_dem(lat, long, square_km, api_key = mapbox_key)

}
}
