% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestfit.R
\name{slopecalc}
\alias{slopecalc}
\title{Determines the Slopes Along the Bearing Area Curve}
\usage{
slopecalc(x, h, f)
}
\arguments{
\item{x}{A vector of x values.}

\item{h}{Spacing before and after each point.
2h is the distance over which slopes are calculated.}

\item{f}{Bearing area function as calculated with
bearing_area.}
}
\value{
A dataframe with the slope for each segment
with centerpoint x.
}
\description{
Calculates the slopes along the bearing area curve
of a raster or matrix. Slopes are determined at points x,
from point x - h to x + h.
}
\examples{
# import raster image
data(normforest)

# find the slopes along the bearing area curve
ba <- bearing_area(normforest)
x <- seq(0, 1, length.out = 100000)
slopes <- slopecalc(x = x, h = 0.01, f = ba)
}
