% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmcmtxZ.R
\name{gmcmtxZ}
\alias{gmcmtxZ}
\title{compute the matrix R* of generalized correlation coefficients.}
\usage{
gmcmtxZ(mym, nam = colnames(mym))
}
\arguments{
\item{mym}{{A matrix of data on variables in columns}}

\item{nam}{{Column names of the variables in the data matrix}}
}
\value{
A non-symmetric R* matrix of generalized correlation coefficients
}
\description{
This function checks for missing data separately for each pair using
\code{kern} function to kernel regress x on y, and conversely y on x. It
 needs the library `np' which reports R-squares of each regression. This function
reports their square roots with the sign of the Pearson correlation coefficients.
Its appeal is that it is asymmetric yielding causal direction information.
It avoids the assumption of linearity implicit in the usual correlation 
coefficients.
}
\note{
This allows the user to change \code{gmcmtx0} and further experiment with my code.
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c('V1', 'v2', 'V3')
gmcmtxZ(x)
}

}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with 
 Applications in Development Economics' in Communications in 
 Statistics -Simulation and Computation, 2015, 
 \url{https://doi.org/gffn86}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{R* asymmetric correlations}
\concept{kernel regression}
