% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{plot_sil}
\alias{plot_sil}
\title{Plots a silhouette read by measuresil()}
\usage{
plot_sil(sil, flip = FALSE, add = FALSE, xoffset = 0, yoffset = 0, ...)
}
\arguments{
\item{sil}{A data frame that is the output of measuresil(..., return="all"), containing the center and the diameter of the silhouette at each value for x.}

\item{flip}{Whether to flip axes (useful if measuresil() was performed using align="v", defaults to FALSE.}

\item{add}{Whether to add to an existing plot}

\item{xoffset}{Optional value by which to shift the silhouette on the x axis}

\item{yoffset}{Optional value by which to shift the silhouette on the y axis}

\item{...}{Other parameters to pass on to plot() or lines()}
}
\value{
A plotted silhouette
}
\description{
Plots a silhouette read by measuresil()
}
\examples{
fdir <- system.file(package="gdi")
measuresil(file.path(fdir,"exdata","lat.png"), return="all")->lat_
plot_sil(lat_)
}
