% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{as_json}
\alias{as_json}
\title{Query data cube properties}
\usage{
as_json(obj)
}
\arguments{
\item{obj}{a data cube proxy object (class cube)}
}
\value{
A JSON string representing a graph (currently a tree) that can be used to create the same
chain of gdalcubes operations.
}
\description{
gdalcubes uses a graph (currently a tree) to serialize data cubes (including chains of cubes). This function gives a JSON
representation, which will be communicated to gdalcubes_server instances to create identical cube instances 
remotely.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-04"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
cat(as_json(select_bands(raster_cube(L8.col, v), c("B04", "B05"))))
}
