% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PeakPosition-class}
\alias{PeakPosition-class}
\alias{.PeakPosition}
\title{An S4 Class to Represent a Set of Peaks}
\description{
An S4 Class to Represent a Set of Peaks
}
\section{Slots}{

\describe{
\item{\code{hash}}{A \code{\link{character}} string giving the 32-byte MD5 hash of
the imported spectrum file.}

\item{\code{noise_method}}{A \code{\link{character}} string specifying the method
used for peak detection.}

\item{\code{noise_threshold}}{A length one \code{\link{numeric}} vector giving the
noise threshold.}

\item{\code{window}}{A length one \code{\link{numeric}} vector giving the half-window
size.}

\item{\code{channel}}{A \code{\link{integer}} vector giving the channel number.
Numeric values are coerced to integer as by \code{\link{as.integer}}
(and hence truncated towards zero).}

\item{\code{energy}}{A \code{\link{numeric}} vector giving the gamma ray's energy
(in keV).}
}}

\note{
This class retains copy construction.
}
\section{Access}{

In the code snippets below, \code{x} is a \code{PeakPosition} object.
\describe{
 \item{\code{get_hash(x)}}{Get the MD5 hash of the raw data file.}
 \item{\code{get_channels(x)}}{Get the channels of \code{x}.}
 \item{\code{get_energy(x)}, \code{set_energy(x) <- value}}{Retrieves or sets
  the energy scale of \code{x} according to \code{value}.}
}
}

\section{Coerce}{

In the code snippets below, \code{x} is a \code{PeakPosition} object.
\describe{
 \item{\code{matrix)}}{Coerces \code{x} to a \code{\link{matrix}}.}
 \item{\code{as.data.frame)}}{Coerces \code{x} to a \code{\link{data.frame}}.}
}
}

\section{Subset}{

In the code snippets below, \code{x} is a \code{PeakPosition} object.
\describe{
 \item{\code{x[[i]]}}{Extracts informations from a slot selected by
 subscript \code{i}. \code{i} is a \code{character} vector
 of length one and will be matched to the name of the slots.}
}
}

\seealso{
Other class: 
\code{\link{Baseline-class}},
\code{\link{CalibrationCurve-class}},
\code{\link{GammaSpectra-class}},
\code{\link{GammaSpectrum-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{class}
