\name{action_spawn}
\alias{g3a_spawn_recruitment_fecundity}
\alias{g3a_spawn_recruitment_simplessb}
\alias{g3a_spawn_recruitment_ricker}
\alias{g3a_spawn_recruitment_bevertonholt}
\alias{g3a_spawn_recruitment_hockeystick}
\alias{g3a_spawn}
\concept{G3 action}

\title{Gadget3 spawning action}
\description{
  Add spawning to a g3 model
}

\usage{
g3a_spawn_recruitment_fecundity(p0, p1, p2, p3, p4)

g3a_spawn_recruitment_simplessb(mu)

g3a_spawn_recruitment_ricker(mu, lambda)

g3a_spawn_recruitment_bevertonholt(mu, lambda)

g3a_spawn_recruitment_hockeystick(r0, blim)

g3a_spawn(
        stock,
        recruitment_f,
        proportion_f = 1,
        mortality_f = 0,
        weightloss_f = 0,
        output_stocks = list(),
        output_ratios = rep(1 / length(output_stocks), times = length(output_stocks)),
        mean_f = g3a_renewal_vonb_t0(by_stock = by_stock),
        stddev_f = g3_parameterized('rec.sd', value = 10, by_stock = by_stock),
        alpha_f = g3_parameterized('walpha', by_stock = wgt_by_stock),
        beta_f = g3_parameterized('wbeta', by_stock = wgt_by_stock),
        by_stock = TRUE,
        wgt_by_stock = TRUE,
        run_f = ~TRUE,
        run_at = g3_action_order$spawn,
        recruit_at = g3_action_order$renewal)
}

\arguments{
  \item{p0,p1,p2,p3,p4}{Substituted into \code{g3a_spawn_recruitment_fecundity} formula, see below.}
  \item{mu,lambda,r0,blim}{Substituted into \code{g3a_spawn_recruitment_*} formula, see below.}
  \item{stock}{
     The mature \code{\link{g3_stock}} that will spawn in this action.
  }
  \item{recruitment_f}{
    A list of \link{formula} generated by one of the \code{g3a_spawn_recruitment_*} functions, containing
    \describe{
      \item{s}{Formula run for each subset of stock}
      \item{r}{Final formula for calculating number of recruits for spawning action}
    }
  }
  \item{proportion_f}{
    \link{formula} generated by one of the \link{g3_suitability_*} functions, describing
    the proportion of stock that will spawn at this timestep.
  }
  \item{mortality_f}{
    \link{formula} generated by one of the \link{g3_suitability_*} functions, describing
    the proportion of spawning stock that will die during spawning.
  }
  \item{weightloss_f}{
    \link{formula} generated by one of the \link{g3_suitability_*} functions, describing
    the overall weight loss during spawning.
  }
  \item{output_stocks}{
    List of \code{\link{g3_stock}}s that will be spawned into.
  }
  \item{output_ratios}{
    Vector of proportions for how to distribute into \var{output_stocks}, summing to 1, default evenly spread.
  }
  \item{mean_f,stddev_f,alpha_f,beta_f}{
    \link{formula} substituted into stock structure calculations, see \link{g3a_renewal_normalparam} for details.
  }
  \item{run_f}{
    \link{formula} specifying a condition for running this action, default always runs.
  }
  \item{run_at}{
    Integer order that spawning actions will be run within model, see \code{\link{g3_action_order}}.
  }
  \item{recruit_at}{
    Integer order that recruitment from spawning will be run within model, see \code{\link{g3_action_order}}.
  }
  \item{by_stock,wgt_by_stock}{Controls how parameters are grouped, see \code{\link{g3_parameterized}}}
}

\details{
  To restrict spawning to a particular step in a year, or a particular area, use \var{run_f}.
  For example:
  \describe{
    \item{\code{cur_step == 1}}{Spawning will happen on first step of every year}
    \item{\code{cur_step == 1 && cur_year >= 1990}}{Spawning will happen on first step of every year after 1990}
    \item{\code{cur_step == 2 && area = 1}}{Spawning will happen on second step of every year, in the first area}
  }

  The action will define the following stock instance variables for each given \var{stock} and \var{output_stock}:
  \describe{
    \item{\var{stock__spawnprop}}{Proportion of (stock) that are spawning in this spawning event}
    \item{\var{stock__spawningnum}}{Numbers of (stock) that are spawning in this spawning event}
    \item{\var{output_stock__spawnednum}}{Numbers of (output_stock) that will be produced in this spawning event}
  }
}

\value{
  \subsection{g3a_spawn_recruitment_fecundity}{A pair of \link{formula} objects:
    \deqn{ S = l ^{p_{1}} a^{p_{2}} (p N_{al})^{p_{3}} W_{al}^{p_{4}} }
    \deqn{ R = p_{0} S }
    \describe{
      \item{\eqn{N_{al}}}{Number of parent stock}
      \item{\eqn{W_{al}}}{Weight of parent stock}
      \item{\eqn{p}}{Proportion of parent stock spawning, from \var{proportion_f}}
      \item{\eqn{p_{0..4}}}{Arguments provided to function}
    }
  }
  \subsection{g3a_spawn_recruitment_simplessb}{A pair of \link{formula} objects:
    \deqn{ S = N_{al} p  W_{al} }
    \deqn{ R = \mu S }
    \describe{
      \item{\eqn{N_{al}}}{Number of parent stock}
      \item{\eqn{W_{al}}}{Weight of parent stock}
      \item{\eqn{p}}{Proportion of parent stock spawning, from \var{proportion_f}}
      \item{\mu}{Argument provided to function}
    }
  }
  \subsection{g3a_spawn_recruitment_ricker}{A pair of \link{formula} objects:
    \deqn{ S = N_{al} p  W_{al} }
    \deqn{ R = \mu S e^{-\lambda S} }
    \describe{
      \item{\eqn{N_{al}}}{Number of parent stock}
      \item{\eqn{W_{al}}}{Weight of parent stock}
      \item{\eqn{p}}{Proportion of parent stock spawning, from \var{proportion_f}}
      \item{\mu}{Argument provided to function}
      \item{\lambda}{Argument provided to function}
    }
  }
  \subsection{g3a_spawn_recruitment_bevertonholt}{A pair of \link{formula} objects:
    \deqn{ S = N_{al} p  W_{al} }
    \deqn{ R = \frac{\mu S}{\lambda + S} }
    \describe{
      \item{\eqn{N_{al}}}{Number of parent stock}
      \item{\eqn{W_{al}}}{Weight of parent stock}
      \item{\eqn{p}}{Proportion of parent stock spawning, from \var{proportion_f}}
      \item{\mu}{Argument provided to function}
      \item{\lambda}{Argument provided to function}
    }
  }
  \subsection{g3a_spawn_recruitment_hockeystick}{A pair of \link{formula} objects:
    \deqn{ S = N_{al} p  W_{al} }
    \deqn{ R = R_0 \min{( S / B_{lim}, 1)} }
    \describe{
      \item{\eqn{N_{al}}}{Number of parent stock}
      \item{\eqn{W_{al}}}{Weight of parent stock}
      \item{\eqn{p}}{Proportion of parent stock spawning, from \var{proportion_f}}
      \item{\eqn{R_0}}{Argument \code{r0} provided to function}
      \item{\eqn{B_{lim}}}{Argument \code{blim} provided to function}
    }
    \strong{NB:} This formula is differentiable, despite using \code{min()} in the
    definition above.
  }
  \subsection{g3a_spawn}{An action (i.e. list of formula objects) that will, for the given \var{stock}...\enumerate{
    \item{Use \var{proportion_f} to calculate the total parent \var{stock} that will spawn}
    \item{Use \var{recruitment_f} to derive the total newly spawned stock}
    \item{Apply \var{weightloss_f} and \var{mortality_f} to the parent \var{stock}}
  } ... then, at recruitment stage ... \enumerate{
    \item{Recruit evenly into \var{output_stocks}, using \var{mean_f}, \var{stddev_f}, \var{alpha_f}, \var{beta_f}
    as-per \link{g3a_renewal_normalparam}}
  }}
}

\seealso{
  \url{https://gadget-framework.github.io/gadget2/userguide/chap-stock.html#sec:stocknatmort},
  \code{\link{g3a_naturalmortality}},
  \code{\link{g3_stock}}
}

\examples{
\dontshow{library(magrittr)}
ling_imm <- g3_stock('ling_imm', seq(20, 156, 4)) \%>\% g3s_age(3, 10)
ling_mat <- g3_stock('ling_mat', seq(20, 156, 4)) \%>\% g3s_age(3, 10)

spawn_action <- g3a_spawn(
    # Spawn from ling_mat
    ling_mat,
    # Use Ricker Recruitment Function to calculate # of recruits from total biomass
    recruitment_f = g3a_spawn_recruitment_ricker(
        g3_parameterized("ricker.mu"),
        g3_parameterized("ricker.lambda")),
    # Proportion of ling_mat spawning exponential relationship based on length
    proportion_f = g3_suitability_exponentiall50(
        alpha = g3_parameterized("spawn.prop.alpha", scale = -1),
        l50 = g3_parameterized("spawn.prop.l50")),
    # Proportion of ling_mat dying during spawning linear relationship to length
    mortality_f = g3_suitability_straightline(
        alpha = g3_parameterized("spawn.mort.alpha"),
        beta = g3_parameterized("spawn.mort.beta")),
    # Weightloss of ling_mat during spawning a constant
    weightloss_f = g3_parameterized("spawn.weightloss"),
    # Spawn into ling_imm
    output_stocks = list(ling_imm),
    # Spawned stock structure, as-per g3a_renewal_normalparam()
    mean_f = 50,
    stddev_f = 0.9,
    alpha_f = 1,
    beta_f = 1,
    # Spawning should happen on the first step of every year
    run_f = ~cur_step==1)
}
