% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{create_edge}
\alias{create_edge}
\title{Configure Create Edge Behavior}
\usage{
create_edge(
  key = "create-edge",
  trigger = "drag",
  enable = FALSE,
  onCreate = NULL,
  onFinish = NULL,
  style = NULL,
  notify = FALSE,
  ...
)
}
\arguments{
\item{key}{Behavior unique identifier. Useful to modify this behavior from JS side.}

\item{trigger}{The way to trigger edge creation: "click" or "drag" (string, default: "drag").}

\item{enable}{Whether to enable this behavior (boolean or function, default: FALSE).
Our default implementation works in parallel with the \link{context_menu} plugin which is
responsible for activating the edge behavior when edge creation is selected.}

\item{onCreate}{Callback function for creating an edge, returns edge data (function, default: NULL).}

\item{onFinish}{Callback function for successfully creating an edge (function).
By default, we provide an internal implementation that disables the edge mode when the edge
creation is succesful so that it does not conflict with other drag behaviors.}

\item{style}{Style of the newly created edge (list, default: NULL).}

\item{notify}{Whether to show a feedback message in the ui.}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/create-edge}.}
}
\value{
A list with the configuration settings for the create-edge behavior.
}
\description{
Creates a configuration object for the create-edge behavior in G6.
This allows users to create edges between nodes by clicking or dragging.
}
\note{
\link{create_edge}, \link{drag_element} and \link{drag_element_force} are incompatible by default,
as there triggers are the same. You can change the trigger to workaround this.
}
\examples{
# Basic configuration
config <- create_edge()
}
