## ---- echo = FALSE, message = FALSE-------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#")
library(funtimes)

## ----eval = FALSE-------------------------------------------------------------
#  ?beales

## -----------------------------------------------------------------------------
discharge <- c(60, 50, 90, 100, 80, 90, 100, 90, 80, 70)
loads <- c(33, 22, 44, 48, NA, 44, 49, NA, NA, 36)

## -----------------------------------------------------------------------------
B10 <- beales(x = discharge, y = loads)

## -----------------------------------------------------------------------------
ls(B10)
B10$se
B10$N

## -----------------------------------------------------------------------------
B11 <- beales(x = discharge, y = loads, level = 0.9)

## -----------------------------------------------------------------------------
B12 <- beales(x = discharge, y = loads, level = 0.9, verbose = FALSE)

## -----------------------------------------------------------------------------
discharge2 <- c(NA, 50, 90, 100, 80, 90, 100, 90, 80, 70)
loads2 <- c(33, 22, 44, 48, NA, 44, 49, NA, NA, 36)

## -----------------------------------------------------------------------------
B20 <- beales(x = discharge2, y = loads2)

## -----------------------------------------------------------------------------
B21 <- beales(x = discharge2, y = loads2, N = 12)

## -----------------------------------------------------------------------------
discharge22 <- c(discharge2, NA, NA)
loads22 <- c(loads2, NA, NA)
B22 <- beales(x = discharge22, y = loads22)

## -----------------------------------------------------------------------------
B30 <- beales(x = discharge2, y = loads2, N = 12, p = 0.05)

## -----------------------------------------------------------------------------
B31 <- beales(x = discharge2, y = loads2, N = 12, p = 0.05, level = 0.99)

## -----------------------------------------------------------------------------
B32 <- beales(x = discharge2, y = loads2, N = 12, d = 15)

## -----------------------------------------------------------------------------
B32$nhat

