\name{hd_data}
\alias{hd_data}
\docType{data}
\title{
Simulated high-dimensional functional time series
}
\description{
We generate \eqn{N} populations of functional time series. For each \eqn{i\in \{1,\dots, N\}}, the \eqn{i}th function at time \eqn{t\in \{1,\dots, T\}} is given by
\deqn{X_t^{(i)}(u) = \sum^2_{p=1}\beta_{p,t}^{(i)}\gamma_p^{(i)}(u) + \theta_t^{(i)}(u),}{X_t^{(i)}(u) = \sum^2_{p=1}\beta_{p,t}^{(i)}\gamma_p^{(i)}(u) + \theta_t^{(i)}(u),}
where \eqn{\theta_t^{(i)}(u) = \sum^{\infty}_{p=3}\beta_{p,t}^{(i)}\gamma_p^{(i)}(u)}.
}
\usage{
data("hd_data")
}
\details{
The coefficients \eqn{\beta_{p,t}^{(i)}} for all \eqn{N} populations are combined and generated, for all \eqn{p\in N}, by
\deqn{\bm{\beta}_{p,t} = \bm{A}_p\bm{f}_{p,t},}{\bm{\beta}_{p,t} = = \bm{A}_p\bm{f}_{p,t},}
where \eqn{\bm{\beta}_{p,t}=\{\beta_{p,t}^{1},\dots,\beta_{p,t}^N\}}. Here, \eqn{\bm{A}_p} is an \eqn{N\times N} matrix, and \eqn{\bm{f}_{p,t}} is an \eqn{N\times 1} vector. Furthermore, we assume that the \eqn{\beta_{p,t}^{(i)}}s have mean 0 and variance 0 when \eqn{p>3}, so we only construct the coefficients \eqn{\bm{\beta}_{p,t}} for \eqn{p\in\{1, 2, 3\}}.

The first set of coefficients \eqn{\bm{\beta}_{1,t}} for \eqn{N} populations are generated with \eqn{\bm{\beta}_{1,t}=\bm{A}_1\bm{f}_{1,t}}. Each element in the matrix \eqn{\bm{A}_1} is generated by \eqn{a_{ij}=N^{-1/4}\times b_{ij}}, where \eqn{b_{ij}\sim N(2,4)}.

The factors \eqn{\bm{f}_{1,t}} are generated using an autoregressive model of order 1, i.e., AR(1). Define the \eqn{i}th element in vector \eqn{\bm{f}_{1,t}} as \eqn{f_{1,t}^{(i)}}. Then, \eqn{f_{1,t}^{1}} is generated by \eqn{f_{1,t}^{1}=0.5\times f_{1,t-1}^{1}+\omega_t}, where \eqn{\omega_t} are independent \eqn{N(0,1)} random variables. We generate \eqn{f_{1,t}^{(i)}} for all \eqn{i\in \{2,\dots, N\}} by \eqn{f_{1,t}^{(i)}=(1/N) \times g_t^{(i)}}, where \eqn{g_t^{(2)},\dots,g_t^{(N)}} are also AR(1) and follow \eqn{g_t^{(i)} = 0.2\times g_{t-1}^{(i)}+\omega_t}. It is then ensured that most of the variance of \eqn{\bm{\beta}_{1,t}} can be explained by one factor. The second coefficient \eqn{\bm{\beta}_{2,t}} are constructed the same way as \eqn{\bm{\beta}_{1,t}}.

We also generate the third functional principal component scores \eqn{\bm{\beta}_{3,t}} but with small values. Moreover, \eqn{\bm{A}_3} is generated by \eqn{a_{ij}=N^{-1/4}\times b_{ij}}, where \eqn{b_{ij}\sim N(0, 0.04)}. The factors \eqn{bm{f}_{3,t}} are generated as \eqn{\bm{f}_{1,t}}.

The three basis functions are constructed by \eqn{\gamma_1^{(i)}(u) = \sin(2\pi u + \pi i/2)}, \eqn{\gamma_2^{(i)}(u) = \cos(2\pi u + \pi i/2)} and \eqn{\gamma_3^{(i)}(u) = \sin(4\pi u + \pi i/2)}, where \eqn{u\in [0,1]}. Finally, the functional time series for the \eqn{i}th population is constructed by
\deqn{\bm{X}_t^{(i)}(u) = \bm{\beta}_{1,t}\gamma_1^{(i)}(u) + \bm{\beta}_{2,t}\gamma_2^{(i)}(u) + \bm{\beta}_{3,t}\gamma_3^{(i)}(u),}{\bm{X}_t^{(i)}(u) = \bm{\beta}_{1,t}\gamma_1^{(i)}(u) + \bm{\beta}_{2,t}\gamma_2^{(i)}(u) + \bm{\beta}_{3,t}\gamma_3^{(i)}(u),}
where \eqn{(\cdot)_i} denotes the \eqn{i}th element of the vector.
}
\references{
Y. Gao, H. L. Shang and Y. Yang (2018) High-dimensional functional time series forecasting: An application to age-specific mortality rates, \emph{Journal of Multivariate Analysis}, \bold{forthcoming}.
}
\seealso{
\code{\link{hdfpca}}, \code{\link{forecast.hdfpca}}
}
\examples{
data(hd_data)
}
\keyword{datasets}
