% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenfrailtyPenal.R
\name{GenfrailtyPenal}
\alias{GenfrailtyPenal}
\title{Fit a Shared or a Joint Frailty Generalized Survival Model}
\usage{
GenfrailtyPenal(formula, formula.terminalEvent, data, recurrentAG = FALSE,
family, hazard = "Splines", n.knots, kappa, betaknots = 1, betaorder = 3,
RandDist = "Gamma", init.B, init.Theta, init.Alpha, Alpha, maxit = 300, 
nb.gh, nb.gl, LIMparam = 1e-3, LIMlogl = 1e-3, LIMderiv = 1e-3, print.times = TRUE, 
cross.validation, jointGeneral, nb.int, initialize, init.Ksi, Ksi, init.Eta)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a
\eqn{\sim} operator, and the terms on the right. The response must be a
survival object as returned by the '\code{Surv}' function 
like in survival package. Interactions are possible using ' * ' or ' : '.}

\item{formula.terminalEvent}{Only for joint frailty models: a formula object,
only requires terms on the right to indicate which variables are used for 
the terminal event.  Interactions are possible using ' * ' or ' : '.}

\item{data}{A 'data.frame' with the variables used in '\code{formula}'.}

\item{recurrentAG}{Logical value. Is Andersen-Gill model fitted? If so
indicates that recurrent event times with the counting process approach of
Andersen and Gill is used. This formulation can be used for dealing with
time-dependent covariates. The default is FALSE.}

\item{family}{Type of Generalized Survival Model to fit.
\code{"PH"} for a proportional hazards model, 
\code{"AH"} for an additive hazards model,
\code{"PO"} for a proportional odds model and 
\code{"probit"} for a probit model. 
A vector of length 2 is expected for joint models 
(e.g., \code{family=c("PH","PH")}).}

\item{hazard}{Type of hazard functions: 
\code{"Splines"} for semi-parametric hazard functions using equidistant 
intervals, or \code{"parametric"} for parametric distribution functions.
In case of \code{family="PH"} or \code{family="AH"}, 
the \code{"parametric"} option corresponds to a Weibull distribution. 
In case of \code{family="PO"} and \code{family="probit"}, 
the \code{"parametric"} option corresponds to a log-logistic 
and a log-normal distribution, respectively. 
So far, the \code{"Splines"} option is only available for PH and AH submodels. 
Default is \code{"Splines"}.}

\item{n.knots}{Integer giving the number of knots to use. Value required in
the penalized likelihood estimation.  It corresponds to the \code{n.knots+2}
splines functions for the approximation of the hazard or the survival
functions. We estimate I- or M-splines of order 4. When the user set a
number of knots equals to \code{k} (i.e. \code{n.knots=k}),
then the number of interior knots is \code{k-2} and the number of splines is 
\code{(k-2)+order}. Number of knots must be between 4 and 20. (See Note)}

\item{kappa}{Positive smoothing parameter in the penalized likelihood
estimation. The coefficient kappa tunes the intensity of the penalization 
(the integral of the squared second derivative of hazard function).
In a stratified shared model, this argument must be a vector
with kappas for both strata. In a stratified joint model, this argument
must be a vector with kappas for both strata for recurrent events plus one
kappa for terminal event.  
We advise the user to identify several possible tuning
parameters, note their defaults and look at the sensitivity of the results
to varying them. Value required. (See Note).}

\item{betaknots}{Number of inner knots used for the 
B-splines time-varying coefficient estimation. Default is 1. 
See '\code{timedep}' function for more details.}

\item{betaorder}{Order of the B-splines used for the 
time-varying coefficient estimation. 
Default is cubic B-splines (\code{order=3}). 
See '\code{timedep}' function for more details. 
Not implemented for Proportional Odds and Probit submodels.}

\item{RandDist}{Type of random effect distribution: 
\code{"Gamma"} for a gamma distribution, 
and \code{"LogN"} for a log-normal distribution (not implemented yet).
Default is \code{"Gamma"}.}

\item{init.B}{A vector of initial values for regression coefficients. This
vector should be of the same size as the whole vector of covariates with the
first elements for the covariates related to the recurrent events and then
to the terminal event (interactions in the end of each component). Default
is 0.1 for each (for Generalized Survival and Shared Frailty Models) 
or 0.5 (for Generalized Joint Frailty Models).}

\item{init.Theta}{Initial value for frailty variance.}

\item{init.Alpha}{Only for Generalized Joint Frailty Models: 
initial value for parameter alpha.}

\item{Alpha}{Only for Generalized Joint Frailty Models: 
input "None" so as to fit a joint model without the parameter alpha.}

\item{maxit}{Maximum number of iterations for the Marquardt algorithm.
Default is 300}

\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature.
It can be chosen among 5, 7, 9, 12, 15, 20 and 32. 
The default is 20 if \code{hazard="Splines"}, 32 otherwise.}

\item{nb.gl}{Number of nodes for the Gaussian-Laguerre quadrature.
It can be chosen between 20 and 32. 
The default is 20 if \code{hazard="Splines"}, 32 otherwise.}

\item{LIMparam}{Convergence threshold of the Marquardt algorithm for the
parameters (see Details), \eqn{10}\out{<sup>-3</sup>} by default.}

\item{LIMlogl}{Convergence threshold of the Marquardt algorithm for the
log-likelihood (see Details), \eqn{10}\out{<sup>-3</sup>} by default.}

\item{LIMderiv}{Convergence threshold of the Marquardt algorithm for the
gradient (see Details), \eqn{10}\out{<sup>-3</sup>} by default.}

\item{print.times}{A logical parameter to print iteration process. Default
is TRUE.}

\item{cross.validation}{Not implemented yet for the generalized settings.}

\item{jointGeneral}{Not implemented yet for the generalized settings.}

\item{nb.int}{Not implemented yet for the generalized settings.}

\item{initialize}{Not implemented yet for the generalized settings.}

\item{init.Ksi}{Not implemented yet for the generalized settings.}

\item{Ksi}{Not implemented yet for the generalized settings.}

\item{init.Eta}{Not implemented yet for the generalized settings.}
}
\value{
The following components are included in a 'frailtyPenal' object for each
model.

\item{b}{Sequence of the corresponding estimation of the coefficients for
the hazard functions (parametric or semiparametric), the random effects
variances and the regression coefficients.} 
\item{call}{The code used for the model.} 
\item{formula}{The formula part of the code used for the model.}
\item{n}{The number of observations used in the fit.} 
\item{groups}{The maximum number of groups used in the fit.} 
\item{n.events}{The number of events observed in the fit.}
\item{n.eventsbygrp}{A vector of length the number of groups 
giving the number of observed events in each group.}
\item{loglik}{The marginal log-likelihood in the parametric case.}
\item{loglikPenal}{The marginal penalized log-likelihood 
in the semiparametric case.}  
\item{coef}{The regression coefficients.} 
\item{varH}{The variance matrix of 
the regression coefficients before positivity constraint transformation. 
Then, the delta method is needed to obtain the estimated variance parameters. 
That is why some variances don't match with 
the printed values at the end of the model.} 
\item{varHtotal}{The variance matrix of 
all the parameters before positivity constraint transformation. 
Then, the delta method is needed to obtain the estimated variance parameters. 
That is why some variances don't match with 
the printed values at the end of the model.} 
\item{varHIH}{The robust estimation of 
the variance matrix of the regression coefficients} 
\item{varHIHtotal}{The robust estimation of 
the variance matrix of all parameters.}
\item{x}{Matrix of times where the hazard functions are estimated.} 
\item{xSu}{Matrix of times where the survival functions are estimated.} 
\item{lam}{Array (dim=3) of baseline hazard estimates 
and confidence bands.}
\item{surv}{Array (dim=3) of baseline survival estimates 
and confidence bands.}
\item{type}{Character string specifying the type of censoring, 
see the \code{Surv} function for more details.}
\item{n.strat}{Number of strata.}
\item{n.iter}{Number of iterations needed to converge.} 
\item{median}{The value of the median survival and its confidence bands. 
If there are two strata or more, the first value corresponds to the value 
for the first strata, etc.}
\item{LCV}{The approximated likelihood cross-validation criterion in the 
semiparametric case. 
With H (resp. H\out{<sub>pen</sub>}) the hessian matrix 
of log-likelihood (resp. penalized log-likelihood), 
EDF = H\out{<sub>pen</sub>}\out{<sup>-1</sup>} H 
the effective degrees of freedom,
L(\eqn{\xi},\eqn{\theta}) the log-likelihood and 
n the number of observations,
\deqn{LCV = 1/n x (trace(EDF) - L(\xi,\theta)).}}
\item{AIC}{The Akaike information Criterion for the parametric case.
With p the number of parameters, 
n the number of observations and L(\eqn{\xi},\eqn{\theta}) the log-likelihood, 
\deqn{AIC = 1/n x (p - L(\xi,\theta)).}}
\item{npar}{Number of parameters.} 
\item{nvar}{Number of explanatory variables.} 
\item{typeof}{Indicator of the type of hazard functions computed : 
0 for "Splines", 2 for "parametric".}
\item{istop}{Convergence indicator: 
1 if convergence is reached, 
2 if convergence is not reached, 
3 if the hessian matrix is not positive definite, 
4 if a numerical problem has occurred in the likelihood calculation}
\item{shape.param}{Shape parameter for the parametric hazard function 
(a Weibull distribution is used for proportional and additive hazards models, 
a log-logistic distribution is used for proportional odds models, 
a log-normal distribution is used for probit models).} 
\item{scale.param}{Scale parameter for the parametric hazard function.}
\item{Names.data}{Name of the dataset.}
\item{Frailty}{Logical value. Was model with frailties fitted ?}
\item{linear.pred}{Linear predictor: 
\bold{\eqn{\beta}}'\bold{\eqn{X}} in the generalized survival models or 
\bold{\eqn{\beta}}'\bold{\eqn{X}} + log(\eqn{u}\out{<sub>i</sub>})
in the shared frailty generalized survival models.}
\item{BetaTpsMat}{Matrix of time varying-effects and confidence bands 
(the first column used for abscissa of times).}
\item{nvartimedep}{Number of covariates with time-varying effects.}
\item{Names.vardep}{Name of the covariates with time-varying effects.}
\item{EPS}{Convergence criteria concerning 
the parameters, the likelihood and the gradient.}
\item{family}{Type of Generalized Survival Model fitted 
(0 for PH, 1 for PO, 2 for probit, 3 for AH).}
\item{global_chisq.test}{A binary variable equals to 0 when no multivariate
Wald is given, 1 otherwise.}
\item{beta_p.value}{p-values of the Wald test for the estimated
regression coefficients.}  
\item{cross.Val}{Logical value. Is cross validation procedure used for 
estimating the smoothing parameters in the penalized likelihood estimation?} 
\item{DoF}{Degrees of freedom associated with the smoothing parameter 
\code{kappa}.} 
\item{kappa}{A vector with the smoothing parameters in the penalized 
likelihood estimation corresponding to each baseline function as components.} 
\item{n.knots}{Number of knots for estimating the baseline functions in the
penalized likelihood estimation.} 
\item{n.knots.temp}{Initial value for the number of knots.} 
\item{global_chisq}{A vector with the values of each multivariate Wald test.} 
\item{dof_chisq}{A vector with the degree of freedom for each multivariate 
Wald test.}
\item{p.global_chisq}{A vector with the p-values for each global multivariate 
Wald test.} 
\item{names.factor}{Names of the "as.factor" variables.} 
\item{Xlevels}{Vector of the values that factor might have taken.} 


The following components are specific to \bold{shared} models.

\item{equidistant}{Indicator for the intervals used in the spline estimation 
of baseline hazard functions : 
1 for equidistant intervals ; 0 for intervals using percentile 
(note: \code{equidistant = 2} in case of parametric estimation).} 
\item{Names.cluster}{Cluster names.}
\item{theta}{Variance of the gamma frailty parameter, i.e. 
Var(\eqn{u}\out{<sub>i</sub>}).}
\item{varTheta}{Variance of parameter \code{theta}.}
\item{theta_p.value}{p-value of the Wald test for 
the estimated variance of the gamma frailty.} 


The following components are specific to \bold{joint} models.

\item{formula}{The formula part of the code 
used for the recurrent events.}
\item{formula.terminalEvent}{The formula part of the code 
used for the terminal model.}
\item{n.deaths}{Number of observed deaths.}
\item{n.censored}{Number of censored individuals.}
\item{theta}{Variance of the gamma frailty parameter, i.e. 
Var(\eqn{u}\out{<sub>i</sub>}).}
\item{indic_alpha}{Indicator if a joint frailty model with 
\eqn{\alpha} parameter was fitted.} 
\item{alpha}{The coefficient \eqn{\alpha} associated 
with the frailty parameter in the terminal hazard function.}
\item{nvar}{A vector with the number of covariates 
of each type of hazard function as components.}
\item{nvarnotdep}{A vector with the number of constant effect covariates  
of each type of hazard function as components.} 
\item{nvarRec}{Number of recurrent explanatory variables.} 
\item{nvarEnd}{Number of death explanatory variables.}
\item{noVar1}{Indicator of recurrent explanatory variables.}
\item{noVar2}{Indicator of death explanatory variables.} 
\item{Names.vardep}{Name of the covariates with time-varying effects 
for the recurrent events.}
\item{Names.vardepdc}{Name of the covariates with time-varying effects 
for the terminal event.}
\item{xR}{Matrix of times where both survival and hazard function 
are estimated for the recurrent event.} 
\item{xD}{Matrix of times for the terminal event.} 
\item{lamR}{Array (dim=3) of hazard estimates and confidence bands
for recurrent event.} 
\item{lamD}{The same value as \code{lamR} for the terminal event.} 
\item{survR}{Array (dim=3) of baseline survival estimates and
confidence bands for recurrent event.} 
\item{survD}{The same value as \code{survR} for the terminal event.} 
\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature.}
\item{nb.gl}{Number of nodes for the Gaussian-Laguerre quadrature.}
\item{medianR}{The value of the median survival for the recurrent events 
and its confidence bands.}
\item{medianD}{The value of the median survival for the terminal event 
and its confidence bands.}
\item{names.factor}{Names of the "as.factor" variables 
for the recurrent events.} 
\item{names.factordc}{Names of the "as.factor" variables 
for the terminal event.}
\item{Xlevels}{Vector of the values that factor might have taken 
for the recurrent events.} 
\item{Xlevels2}{Vector of the values that factor might have taken 
for the terminal event.}  
\item{linear.pred}{Linear predictor for the recurrent part: 
\bold{\eqn{\beta}}'\bold{\eqn{X}} + log(\eqn{u}\out{<sub>i</sub>}).} 
\item{lineardeath.pred}{Linear predictor for the terminal part: 
\bold{\eqn{\beta}}'\bold{\eqn{X}} + \eqn{\alpha} x log(\eqn{u}\out{<sub>i</sub>}).} 
\item{Xlevels}{Vector of the values that factor might have taken 
for the recurrent part.}
\item{Xlevels2}{vector of the values that factor might have taken 
for the death part.} 
\item{BetaTpsMat}{Matrix of time varying-effects and confidence bands for 
recurrent event (the first column used for abscissa of times of recurrence).} 
\item{BetaTpsMatDc}{Matrix of time varying-effects and confidence bands for 
terminal event (the first column used for abscissa of times of death).} 
\item{alpha_p.value}{p-value of the Wald test for the estimated \eqn{\alpha}.}
}
\description{
{

\if{html}{\bold{I. SHARED FRAILTY GENERALIZED SURVIVAL MODELS}

Fit a gamma Shared Frailty Generalized Survival Model using 
a parametric estimation, or a semi-parametric penalized likelihood estimation.
Right-censored data and strata (up to 6 levels) are allowed. 
It allows to obtain a parametric or flexible semi-parametric smooth 
hazard and survival functions.

Each frailty term \eqn{u}\out{<sub>i</sub>} is assumed 
to act multiplicatively on the hazard function, and to be drawn from a 
Gamma distribution with unit mean and variance \eqn{\theta}.
Conditional on the frailty term, the hazard function for the 
\eqn{j}\out{<sup>th</sup>} subject in the \eqn{i}\out{<sup>th</sup>} group 
is then expressed by

{\figure{gsm1.png}{options: width="70\%"}}

where \bold{\eqn{x}}\out{<sub>ij</sub>} 
is a collection of baseline covariates, 
\bold{\eqn{\xi}} is a vector of parameters, and 
\eqn{\lambda}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>} ; \bold{\eqn{\xi}}) 
is the hazard function for an average value of the frailty.
The associated conditional survival function writes

{\figure{gsm2.png}{options: width="70\%"}}

where 
\eqn{S}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>} ; \bold{\eqn{\xi}})
designates the survival function for an average value of the frailty.

Following Liu et al. (2017, 2018), the latter function is expressed in terms of 
a link function \eqn{g}(.) and a linear predictor 
\eqn{\eta}\out{<sub>ij</sub>}
(\eqn{t}, \bold{\eqn{x}}\out{<sub>ij</sub>}; \bold{\eqn{\xi}}) 
such that 
\eqn{g}[\eqn{S}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>} ; \bold{\eqn{\xi}})] 
= 
\eqn{\eta}\out{<sub>ij</sub>}
(\eqn{t}, \bold{\eqn{x}}\out{<sub>ij</sub>}; \bold{\eqn{\xi}}), 
i.e. 
\eqn{S}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>} ; \bold{\eqn{\xi}}) 
= 
\eqn{h}[\eqn{\eta}\out{<sub>ij</sub>}
(\eqn{t}, \bold{\eqn{x}}\out{<sub>ij</sub>}; \bold{\eqn{\xi}})]
with \eqn{h}() = \eqn{g}\out{<sup>-1</sup>}().

The conditional survival function is finally modeled by

{\figure{gsm3.png}{options: width="70\%"}}

The table below summarizes the most commonly used (inverse) link functions and 
their associated conditional survival, hazard and cumulative hazard functions.
PHM stands for "Proportional Hazards Model", 
POM for "Proportional Odds Model, 
PROM for "Probit Model" and AHM for "Additive Hazards Model".

{\figure{gsm4.png}{options: width="100\%"}}


\bold{I.(a) Fully parametric case}

In the fully parametric case, linear predictors considered are of the form

{\figure{gsm5.png}{options: width="70\%"}}

where \eqn{\rho > 0} is a shape parameter, 
\eqn{\gamma > 0} a scale parameter, 
\bold{\eqn{\beta}} a vector of regression coefficients, 
and \bold{\eqn{\xi}} = (\eqn{\rho} ,\eqn{\gamma}, \bold{\eqn{\beta}}).
With the appropriate link function, such linear parametric predictors 
make it possible to recover 
a Weibull baseline survival function for PHMs and AHMs, 
a log-logistic baseline survival function for POMs, 
and a log-normal one for PROMs. 

\bold{I. (b) Flexible semi-parametric case}

For PHM and AHM, a more flexible splines-based approach is proposed for 
modeling the baseline hazard function and time-varying regression coefficients.
In this case, conditional on the frailty term \eqn{u}\out{<sub>i</sub>}, 
the hazard function for the \eqn{j}\out{<sup>th</sup>} subject 
in the \eqn{i}\out{<sup>th</sup>} group is still expressed by
\eqn{\lambda}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>}, \eqn{u}\out{<sub>i</sub>} ; 
\bold{\eqn{\xi}}) 
= \eqn{u}\out{<sub>i</sub>} 
\eqn{\lambda}\out{<sub>ij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>ij</sub>} ; \bold{\eqn{\xi}}), 
but we have this time 

{\figure{gsm6.png}{options: width="70\%"}}

The smoothness of baseline hazard function \eqn{\lambda}\out{<sub>0</sub>}() 
is ensured by penalizing the log-likelihood by a term which has 
large values for rough functions. 

Moreover, for parametric and flexible semi-parametric AHMs, the 
log-likelihood is constrained to ensure the strict positivity of the hazards, 
since the latter is not naturally guaranteed by the model.



\bold{II. JOINT FRAILTY GENERALIZED SURVIVAL MODELS}

Fit a gamma Joint Frailty Generalized Survival Model for recurrent and
terminal events using a parametric estimation, 
or a semi-parametric penalized likelihood estimation. 
Right-censored data and strata (up to 6 levels) for the recurrent event part 
are allowed. 
Joint frailty models allow studying, jointly, survival processes
of recurrent and terminal events, by considering the terminal event as an
informative censoring.

This model includes an common patient-specific frailty term 
\eqn{u}\out{<sub>i</sub>} for the two survival functions which will 
take into account the unmeasured heterogeneity in the data, 
associated with unobserved covariates. 
The frailty term acts differently for the two survival functions 
(\eqn{u}\out{<sub>i</sub>} for the recurrent survival function and 
\eqn{u}\out{<sub>i</sub>}\out{<sup>&#945;</sup>} for the death one). 
The covariates could be different for the recurrent and terminal event parts.

\bold{II.(a) Fully parametric case}

For the \eqn{j}\out{<sup>th</sup>} recurrence (j=1,...,n\out{<sub>i</sub>}) 
and the \eqn{i}\out{<sup>th</sup>} patient (i=1,...,N), 
the gamma Joint Frailty Generalized Survival Model 
for recurrent event survival function 
\eqn{S}\out{<sub>Rij</sub>}(.) and death survival function 
\eqn{S}\out{<sub>Di</sub>}(.) is

{\figure{gsm7.png}{options: width="70\%"}}

- \eqn{\eta}\out{<sub>Rij</sub>} (resp. \eqn{\eta}\out{<sub>Di</sub>}) 
is the linear predictor for the recurrent (resp. terminal) event process.
The form of these linear predictors is the same as the one presented in I.(a).

- \eqn{h}\out{<sub>R</sub>}(.) (resp. \eqn{h}\out{<sub>D</sub>}(.)) 
is the inverse link function associated with 
recurrent events (resp. terminal event).

- \bold{\eqn{x}}\out{<sub>Rij</sub>} and \bold{\eqn{x}}\out{<sub>Di</sub>}
are two vectors of baseline covariates associated with 
recurrent and terminal events.

- \bold{\eqn{\xi}}\out{<sub>R</sub>} and \bold{\eqn{\xi}}\out{<sub>D</sub>} 
are the parameter vectors for recurrent and terminal events.

- \eqn{\alpha} is a parameter allowing more flexibility in the association 
between recurrent and terminal events processes.

- The random frailties \eqn{u}\out{<sub>i</sub>} are still assumed iid and 
drown from a \eqn{\Gamma}(1/\eqn{\theta},1/\eqn{\theta}).


\bold{II.(b) Flexible semi-parametric case}

If one chooses to fit a PHM or an AHM for recurrent and/or terminal events, 
a splines-based approach for modeling baseline hazard functions 
and time-varying regression coefficients is still available. 
In this approach, the submodel for recurrent events is expressed as
\eqn{\lambda}\out{<sub>Rij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>Rij</sub>}, \eqn{u}\out{<sub>i</sub>} ; 
\bold{\eqn{\xi}}\out{<sub>R</sub>}) 
= \eqn{u}\out{<sub>i</sub>} 
\eqn{\lambda}\out{<sub>Rij</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>Rij</sub>} ; 
\bold{\eqn{\xi}}\out{<sub>R</sub>}), where 

{\figure{gsm8.png}{options: width="70\%"}}

The submodel for terminal event is expressed as
\eqn{\lambda}\out{<sub>Di</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>Di</sub>}, \eqn{u}\out{<sub>i</sub>} ; 
\bold{\eqn{\xi}}\out{<sub>D</sub>}) 
= \eqn{u}\out{<sub>i</sub>}\out{<sup>&#945;</sup>} 
\eqn{\lambda}\out{<sub>Di</sub>}
(\eqn{t} | \bold{\eqn{x}}\out{<sub>Di</sub>} ; 
\bold{\eqn{\xi}}\out{<sub>D</sub>}), where 

{\figure{gsm9.png}{options: width="70\%"}}

Baseline hazard functions 
\eqn{\lambda}\out{<sub>R0</sub>}(.) and \eqn{\lambda}\out{<sub>D0</sub>}(.)
are estimated using cubic M-splines (of order 4) 
with positive coefficients, and the time-varying coefficients 
\eqn{\beta}\out{<sub>R</sub>}(.) and \eqn{\beta}\out{<sub>D</sub>}(.)
are estimated using B-splines of order q.

The smoothness of baseline hazard functions
is ensured by penalizing the log-likelihood by two terms 
which has large values for rough functions. 

Moreover, 
if one chooses an AHM for recurrent and/or terminal event submodel,
the log-likelihood is constrained to ensure 
the strict positivity of the hazards, 
since the latter is not naturally guaranteed by the model.


}
\if{latex}{\bold{Shared Frailty model}

Fit a shared gamma or log-normal frailty model using a semiparametric
Penalized Likelihood estimation or parametric estimation on the hazard
function. Left-truncated, right-censored data, interval-censored data and
strata (up to 6 levels) are allowed. It allows to obtain a non-parametric
smooth hazard of survival function. This approach is different from the
partial penalized likelihood approach of Therneau et al.

The hazard function, conditional on the frailty term \eqn{\omega_i}, of a
shared gamma frailty model for the \eqn{j^{th}} subject in the \eqn{i^{th}}
group:

\deqn{\lambda_{ij}(t|\omega_i)=\lambda_0(t)\omega_i\exp(\bold{\beta^{'}Z_{ij}})}

\deqn{\omega_i\sim\Gamma\left(\frac{1}{\theta},\frac{1}{\theta}\right)
\hspace{0.5cm} \bold{E}(\omega_i)=1
\hspace{0.5cm}\bold{Var}(\omega_i)=\theta}

where \eqn{\lambda_0(t)} is the baseline hazard function, \eqn{\bold{\beta}}
the vector of the regression coefficient associated to the covariate vector
\eqn{\bold{Z_{ij}}} for the \eqn{j^{th}} individual in the \eqn{i^{th}}
group.

Otherwise, in case of a shared log-normal frailty model, we have for the
\eqn{j^{th}} subject in the \eqn{i^{th}} group:

\deqn{\lambda_{ij}(t|\eta_i)=\lambda_0(t)\exp(\eta_i+\bold{\beta^{'}Z_{ij}})}

\deqn{\eta_i\sim N(0,\sigma^2)}

From now on, you can also consider time-varying effects covariates in your
model, see \code{timedep} function for more details.

\bold{Joint Frailty model}

Fit a joint either with gamma or log-normal frailty model for recurrent and
terminal events using a penalized likelihood estimation on the hazard
function or a parametric estimation. Right-censored data and strata (up to 6
levels) for the recurrent event part are allowed. Left-truncated data is not
possible. Joint frailty models allow studying, jointly, survival processes
of recurrent and terminal events, by considering the terminal event as an
informative censoring.

There is two kinds of joint frailty models that can be fitted with
\code{GenfrailtyPenal} :

- The first one (Rondeau et al. 2007) includes a common frailty term to the
individuals \eqn{(\omega_i)} for the two rates which will take into account
the heterogeneity in the data, associated with unobserved covariates. The
frailty term acts differently for the two rates ( \eqn{\omega_i} for the
recurrent rate and \eqn{\omega_i^{\alpha}} for the death rate). The
covariates could be different for the recurrent rate and death rate.

For the \eqn{j^{th}}{j^th} recurrence \eqn{(j=1,...,n_i)} and the
\eqn{i^{th}}{i^th} subject \eqn{(i=1,...,G)}, the joint gamma frailty model
for recurrent event hazard function \eqn{r_{ij}(.)} and death rate
\eqn{\lambda_i(.)} is :

\deqn{\left\{ \begin{array}{ll}
r_{ij}(t|\omega_i)=\omega_ir_0(t)\exp(\bold{\beta_1^{'}Z_i(t)}) &
\mbox{(Recurrent)} \\
\lambda_i(t|\omega_i)=\omega_i^{\alpha}\lambda_0(t)\exp(\bold{\beta_2^{'}Z_i(t)})
& \mbox{(Death)} \\ \end{array} \right. }

where \eqn{r_0(t)} (resp. \eqn{\lambda_0(t)}) is the recurrent (resp.
terminal) event baseline hazard function, \eqn{\bold{\beta_1}} (resp.
\eqn{\bold{\beta_2}}) the regression coefficient vector, \eqn{\bold{Z_i(t)}}
the covariate vector. The random effects of frailties
\eqn{\omega_i\sim\bold{\Gamma}(\frac{1}{\theta},\frac{1}{\theta})} and are
iid.

The joint log-normal frailty model will be :

\deqn{\left\{ \begin{array}{ll}
r_{ij}(t|\eta_i)=r_0(t)\exp(\eta_i+\bold{\beta_1^{'}Z_i(t)}) &
\mbox{(Recurrent)} \\ \lambda_i(t|\eta_i)=\lambda_0(t)\exp(\alpha
\eta_i+\bold{\beta_2^{'}Z_i(t)}) & \mbox{(Death)} \\ \end{array} \right. }

where \deqn{\eta_i\sim N(0,\sigma^2)}

- The second one (Rondeau et al. 2011) is quite similar but the frailty term
is common to the individuals from a same group. This model is useful for the
joint modelling two clustered survival outcomes. This joint models have been
developed for clustered semi-competing events. The follow-up of each of the
two competing outcomes stops when the event occurs. In this case, j is for
the subject and i for the cluster.

\deqn{\left\{ \begin{array}{ll}
r_{ij}(t|u_i)=u_ir_0(t)\exp(\bold{\beta_1^{'}Z_{ij}(t)}) & \mbox{(Time to
event)} \\
\lambda_{ij}(t|u_i)=u_i^{\alpha}\lambda_0(t)\exp(\bold{\beta_2^{'}Z_{ij}(t)})
& \mbox{(Death)} \\ \end{array} \right. }

It should be noted that in these models it is not recommended to include
\eqn{\alpha} parameter as there is not enough information to estimate it and
thus there might be convergence problems.

In case of a log-normal distribution of the frailties, we will have :

\deqn{\left\{ \begin{array}{ll}
r_{ij}(t|v_i)=r_0(t)\exp(v_i+\bold{\beta_1^{'}Z_{ij}(t)}) & \mbox{(Time to
event)} \\ \lambda_{ij}(t|v_i)=\lambda_0(t)\exp(\alpha
v_i+\bold{\beta_2^{'}Z_{ij}(t)}) & \mbox{(Death)} \\ \end{array} \right. }

where \deqn{v_i\sim N(0,\sigma^2)}

This joint frailty model can also be applied to clustered recurrent events
and a terminal event (example on "readmission" data below).

From now on, you can also consider time-varying effects covariates in your
model, see \code{timedep} function for more details.

There is a possibility to use a weighted penalized maximum likelihood
approach for nested case-control design, in which risk set sampling is
performed based on a single outcome (Jazic et al., \emph{Submitted}).

General Joint Frailty model Fit a general joint frailty model for recurrent
and terminal events considering two independent frailty terms. The frailty
term \eqn{u_i} represents the unobserved association between recurrences and
death. The frailty term \eqn{v_i} is specific to the recurrent event rate.
Thus, the general joint frailty model is:

\eqn{\left\{ \begin{array}{ll}
r_{ij}(t|u_i,v_i)=u_iv_ir_0(t)\exp(\bold{\beta_1^{'}Z_{ij}(t)})
=u_iv_ir_{ij}(t) & \mbox{(Recurrent)} \\
\lambda_{i}(t|u_i)=u_i\lambda_0(t)\exp(\bold{\beta_1^{'}Z_{i}(t)}) = u_i
\lambda_{i}(t) & \mbox{(Death)} \\ \end{array} \right. }

where the \eqn{iid} random effects
\eqn{\bold{u_i}\sim\Gamma(\frac{1}{\theta},\frac{1}{\theta})} and the
\eqn{iid} random effects
\eqn{\bold{v_i}\sim\Gamma(\frac{1}{\eta},\frac{1}{\eta})} are independent
from each other.  The joint model is fitted using a penalized likelihood
estimation on the hazard. Right-censored data and time-varying covariates
\eqn{\bold{Z}_i(t)} are allowed.

\bold{Nested Frailty model}

\bold{\emph{Data should be ordered according to cluster and subcluster}}

Fit a nested frailty model using a Penalized Likelihood on the hazard
function or using a parametric estimation. Nested frailty models allow
survival studies for hierarchically clustered data by including two iid
gamma random effects. Left-truncated and right-censored data are allowed.
Stratification analysis is allowed (maximum of strata = 2).

The hazard function conditional on the two frailties \eqn{v_i} and
\eqn{w_{ij}} for the \eqn{k^{th}} individual of the \eqn{j^{th}} subgroup of
the \eqn{i^{th}} group is :

\deqn{\left\{ \begin{array}{ll}
\lambda_{ijk}(t|v_i,w_{ij})=v_iw_{ij}\lambda_0(t)exp(\bold{\beta^{'}X_{ijk}})
\\ v_i\sim\Gamma\left(\frac{1}{\alpha},\frac{1}{\alpha}\right)
\hspace{0.05cm}i.i.d. \hspace{0.2cm} \bold{E}(v_i)=1
\hspace{0.2cm}\bold{Var}(v_i)=\alpha \\
w_{ij}\sim\Gamma\left(\frac{1}{\eta},\frac{1}{\eta}\right)\hspace{0.05cm}i.i.d.
\hspace{0.2cm} \bold{E}(w_{ij})=1 \hspace{0.2cm} \bold{Var}(w_{ij})=\eta
\end{array} \right. }

where \eqn{\lambda_0(t)} is the baseline hazard function, \eqn{X_{ijk}}
denotes the covariate vector and \eqn{\beta} the corresponding vector of
regression parameters.

\bold{Joint Nested Frailty Model}

Fit a joint model for recurrent and terminal events using a penalized
likelihood on the hazard functions or a parametric estimation.
Right-censored data are allowed but left-truncated data and stratified
analysis are not allowed.

Joint nested frailty models allow studying, jointly, survival processes of
recurrent and terminal events for hierarchically clustered data, by
considering the terminal event as an informative censoring and by including
two iid gamma random effects.

The joint nested frailty model includes two shared frailty terms, one for
the subgroup (\eqn{u_{fi}}) and one for the group (\eqn{w_f}) into the
hazard functions. This random effects account the heterogeneity in the data,
associated with unobserved covariates. The frailty terms act differently for
the two rates (\eqn{u_{fi}}, \eqn{w_f^\xi} for the recurrent rate and
\eqn{u_{fi}^\alpha, {w_i}} for the terminal event rate). The covariates
could be different for the recurrent rate and death rate.

For the \eqn{j^{th}} recurrence (j = 1, ..., \eqn{n_i}) of the \eqn{i^{th}}
individual (i = 1, ..., \eqn{m_f}) of the \eqn{f^{th}} group (f = 1, ...,
n), the joint nested gamma frailty model for recurrent event hazard function
\eqn{r_{fij}}(.) and for terminal event hazard function \eqn{\lambda_{fi}}
is :

\deqn{\left\{ \begin{array}{ll} r_{fij}(t|\omega_f, u_{fi}, \bold{X_{fij}})=
r_0(t) u_{fi} \omega_f^\xi \exp(\bold{\beta'} \bold{X_{fij}}) &
\mbox{(Recurrent)} \\ \lambda_{fi}(t|\omega_f, u_{fi},
\bold{X_{fij}})=\lambda_0(t)u_{fi}^\alpha \omega_f \exp(\bold{\gamma'}
\bold{X_{fi}}) & \mbox{(Death)} \\ \end{array} \right. }

where \eqn{r_0(t)}(resp. \eqn{\lambda_0(t)}) is the recurrent (resp.
terminal) event baseline hazard function, \eqn{\beta} (resp. \eqn{\gamma})
the regression coefficient vector, \eqn{\bold{X_{fij}}(t)} the covariates
vector. The random effects are \deqn{\omega_f \sim \Gamma \left(
\frac{1}{\eta}, \frac{1}{\eta}\right)} and \deqn{ u_{fi} \sim \Gamma \left(
\frac{1}{\theta}, \frac{1}{\theta} \right)}
}
}
}
\details{
{
\bold{TYPICAL USES}

For a Generalized Survival Model:
\preformatted{GenfrailtyPenal(
formula=Surv(time,event)~var1+var2, 
data, family, \dots)}

For a Shared Frailty Generalized Survival Model:
\preformatted{GenfrailtyPenal(
formula=Surv(time,event)~cluster(group)+var1+var2, 
data, family, \dots)}

For a Joint Frailty Generalized Survival Model:
\preformatted{GenfrailtyPenal(
formula=Surv(time,event)~cluster(group)+var1+var2+var3+terminal(death), 
formula.terminalEvent= ~var1+var4, 
data, family, \dots)}


\bold{OPTIMIZATION ALGORITHM}

The estimated parameters are obtained using the robust Marquardt algorithm
(Marquardt, 1963) which is a combination between a Newton-Raphson algorithm
and a steepest descent algorithm. The iterations are stopped when 
the difference between two consecutive log-likelihoods is small 
(\eqn{<10}\out{<sup>-3</sup>}), 
the estimated coefficients are stable 
(consecutive values \eqn{<10}\out{<sup>-3</sup>}, 
and the gradient small enough (\eqn{<10}\out{<sup>-3</sup>}). 
When the frailty variance is small, numerical problems may arise. 
To solve this problem, an alternative formula of the penalized log-likelihood 
is used (see Rondeau, 2003 for further details). 
For Proportional Hazards and Additive Hazards submodels, 
cubic M-splines of order 4 can be used to estimate the hazard function. 
In this case, I-splines (integrated M-splines) are used to compute the
cumulative hazard function.

The inverse of the Hessian matrix is the variance estimator. 
To deal with the positivity constraint of the variance component and the 
spline coefficients, a squared transformation is used and the standard errors 
are computed by the \eqn{\Delta}-method (Knight & Xekalaki, 2000). 
The integrations in the full log likelihood are evaluated using 
Gaussian quadrature. Laguerre polynomials with 20 points are used to treat 
the integrations on \eqn{[0,\infty[}.


\bold{INITIAL VALUES}

In case of a shared frailty model, 
the splines and the regression coefficients are initialized to 0.1. 
The program fits, firstly, an adjusted Cox model to give new initial values 
for the splines and the regression coefficients. 
The variance of the frailty term \eqn{\theta} is initialized to 0.1. 
Then, a shared frailty model is fitted.

In case of a joint frailty model, 
the splines and the regression coefficients are initialized to 0.5. 
The program fits firstly, an adjusted Cox model to have new initial values 
for the splines and the regression coefficients.
The variance of the frailty term \eqn{\theta} and the association parameter
\eqn{\alpha} are initialized to 1.
Then, a joint frailty model is fitted.

}
}
\note{
In the flexible semiparametric case, smoothing parameters \code{kappa} and 
number of knots \code{n.knots} are the arguments that the user have to change 
if the fitted model does not converge. 
\code{n.knots} takes integer values between 4 and 20. 
But with \code{n.knots=20}, the model would take a long time to converge. 
So, usually, begin first with \code{n.knots=7}, and increase it step by step 
until it converges.
\code{kappa} only takes positive values. So, choose a value for kappa (for
instance 10000), and if it does not converge, multiply or divide this value
by 10 or 5 until it converges.
}
\examples{
\dontrun{

#############################################################################
# -----        GENERALIZED SURVIVAL MODELS (without frailties)       -----  #
#############################################################################

library(timereg)
adult.retino = retinopathy[retinopathy$type == "adult", ]
adult.retino[adult.retino$futime >= 50, "status"] = 0
adult.retino[adult.retino$futime >= 50, "futime"] = 50

### ---  Parametric PH, AH, PO and probit models  --- ###

GenfrailtyPenal(formula=Surv(futime,status)~trt, data=adult.retino, 
hazard="parametric", family="PH")
GenfrailtyPenal(formula=Surv(futime,status)~trt, data=adult.retino, 
hazard="parametric", family="AH")
GenfrailtyPenal(formula=Surv(futime,status)~trt, data=adult.retino, 
hazard="parametric", family="PO")
GenfrailtyPenal(formula=Surv(futime,status)~trt, data=adult.retino, 
hazard="parametric", family="probit")

### ---  Semi-parametric PH and AH models  --- ###

GenfrailtyPenal(formula=Surv(futime,status)~timedep(trt), data=adult.retino, 
family="PH", hazard="Splines", n.knots=8, kappa=10^6, betaknots=1, betaorder=2)
GenfrailtyPenal(formula=Surv(futime,status)~timedep(trt), data=adult.retino, 
family="AH", hazard="Splines", n.knots=8, kappa=10^10, betaknots=1, betaorder=2)



#############################################################################
# -----          SHARED FRAILTY GENERALIZED SURVIVAL MODELS          -----  #
#############################################################################

library(timereg)
adult.retino = retinopathy[retinopathy$type == "adult", ]
adult.retino[adult.retino$futime >= 50, "status"] = 0
adult.retino[adult.retino$futime >= 50, "futime"] = 50

### ---  Parametric PH, AH, PO and probit models  --- ###

GenfrailtyPenal(formula=Surv(futime,status)~trt+cluster(id), data=adult.retino, 
hazard="parametric", family="PH")
GenfrailtyPenal(formula=Surv(futime,status)~trt+cluster(id), data=adult.retino, 
hazard="parametric", family="AH")
GenfrailtyPenal(formula=Surv(futime,status)~trt+cluster(id), data=adult.retino, 
hazard="parametric", family="PO")
GenfrailtyPenal(formula=Surv(futime,status)~trt+cluster(id), data=adult.retino, 
hazard="parametric", family="probit")

### ---  Semi-parametric PH and AH models  --- ###

GenfrailtyPenal(formula=Surv(futime,status)~cluster(id)+timedep(trt), 
data=adult.retino, family="PH", hazard="Splines", 
n.knots=8, kappa=10^6, betaknots=1, betaorder=2)
GenfrailtyPenal(formula=Surv(futime,status)~cluster(id)+timedep(trt), 
data=adult.retino, family="AH", hazard="Splines", 
n.knots=8, kappa=10^10, betaknots=1, betaorder=2)



#############################################################################
# -----         JOINT FRAILTY GENERALIZED SURVIVAL MODELS            -----  #
#############################################################################

data("readmission") 
readmission[, 3:5] = readmission[, 3:5]/365.25

### ---  Parametric dual-PH, AH, PO and probit models  --- ###

GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+chemo,
formula.terminalEvent=~sex+dukes+chemo, data=readmission, recurrentAG=TRUE, 
hazard="parametric", family=c("PH","PH"))
GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+chemo,
formula.terminalEvent=~sex+dukes+chemo, data=readmission, recurrentAG=TRUE, 
hazard="parametric", family=c("AH","AH"))
GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+chemo,
formula.terminalEvent=~sex+dukes+chemo, data=readmission, recurrentAG=TRUE, 
hazard="parametric", family=c("PO","PO"))
GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+chemo,
formula.terminalEvent=~sex+dukes+chemo, data=readmission, recurrentAG=TRUE, 
hazard="parametric", family=c("probit","probit"))

### ---  Semi-parametric dual-PH and AH models  --- ###

GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+timedep(chemo),
formula.terminalEvent=~sex+dukes+timedep(chemo), data=readmission, recurrentAG=TRUE, 
hazard="Splines", family=c("PH","PH"), 
n.knots=5, kappa=c(100,100), betaknots=1, betaorder=3)
GenfrailtyPenal(
formula=Surv(t.start,t.stop,event)~cluster(id)+terminal(death)+sex+dukes+timedep(chemo),
formula.terminalEvent=~sex+dukes+timedep(chemo), data=readmission, recurrentAG=TRUE, 
hazard="Splines", family=c("AH","AH"), 
n.knots=5, kappa=c(600,600), betaknots=1, betaorder=3)

}


}
\references{
J. Chauvet and V. Rondeau (2021). A flexible class of generalized 
joint frailty models for the analysis of survival endpoints. In revision.

Liu XR, Pawitan Y, Clements M. (2018)
Parametric and penalized generalized survival models. 
\emph{Statistical Methods in Medical Research} \bold{27}(5), 1531-1546.

Liu XR, Pawitan Y, Clements MS. (2017)
Generalized survival models for correlated time-to-event data. 
\emph{Statistics in Medicine} \bold{36}(29), 4743-4762.

A. Krol, A. Mauguen, Y. Mazroui, A. Laurent, S. Michiels and V. Rondeau
(2017). Tutorial in Joint Modeling and Prediction: A Statistical Software
for Correlated Longitudinal Outcomes, Recurrent Events and a Terminal Event.
\emph{Journal of Statistical Software} \bold{81}(3), 1-52.

V. Rondeau, Y. Mazroui and J. R. Gonzalez (2012). Frailtypack: An R package
for the analysis of correlated survival data with frailty models using
penalized likelihood estimation or parametric estimation. \emph{Journal of
Statistical Software} \bold{47}, 1-28.

V. Rondeau, J.P. Pignon, S. Michiels (2011). A joint model for the
dependance between clustered times to tumour progression and deaths: A
meta-analysis of chemotherapy in head and neck cancer. \emph{Statistical
methods in medical research} \bold{897}, 1-19.

V. Rondeau, S. Mathoulin-Pellissier, H. Jacqmin-Gadda, V. Brouste, P.
Soubeyran (2007). Joint frailty models for recurring events and death using
maximum penalized likelihood estimation:application on cancer events.
\emph{Biostatistics} \bold{8},4, 708-721.

V. Rondeau, D. Commenges, and P. Joly (2003). Maximum penalized likelihood
estimation in a gamma-frailty model. \emph{Lifetime Data Analysis} \bold{9},
139-153.

C.A. McGilchrist, and C.W. Aisbett (1991). Regression with frailty in
survival analysis. \emph{Biometrics} \bold{47}, 461-466.

D. Marquardt (1963). An algorithm for least-squares estimation of nonlinear
parameters. \emph{SIAM Journal of Applied Mathematics}, 431-441.
}
\seealso{
\code{\link{Surv}}, 
\code{\link{terminal}}, 
\code{\link{timedep}}
}
\keyword{models}
