% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transect_length.R
\name{get_transect_length}
\alias{get_transect_length}
\title{Get transect length of PCL transect (in meters)}
\usage{
get_transect_length(df, marker.spacing)
}
\arguments{
\item{df}{data frame of unprocessed PCL data}

\item{marker.spacing}{distance between transect markers, typically 5 or 10 m}
}
\value{
length of transect
}
\description{
\code{get_transect_length} acquires the length of a transect based on
a known marker spacing of the data markers stored in pcl data.
}
\details{
Returns the transect length of a given PCL file given a known marker spacing.
}
\examples{

# Get the length of the transect given a known spacing between data markers
transect.length <- get_transect_length(pcl_data, marker.spacing = 10)

}
