% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{multivariate-optimization}
\alias{multivariate-optimization}
\alias{cg1}
\alias{cg2}
\alias{bfgs1}
\alias{bfgs2}
\alias{lbfgsb1}
\alias{lbfgsb2}
\alias{neldermead}
\alias{nlm1}
\alias{nlm2}
\alias{nlm3}
\title{Multivariate Optimization}
\usage{
cg1(init, f, g, args)

cg2(init, f, args)

bfgs1(init, f, g, args)

bfgs2(init, f, args)

lbfgsb1(init, f, g, args)

lbfgsb2(init, f, args)

neldermead(init, f, args)

nlm1(init, f, g, h, args)

nlm2(init, f, g, args)

nlm3(init, f, args)
}
\arguments{
\item{init}{Initial value}

\item{f}{Function \eqn{f} to optimize}

\item{g}{Gradient function of \eqn{f}.}

\item{args}{List of additional arguments for optimization.}

\item{h}{Hessian function of \eqn{f}.}
}
\value{
A list with results corresponding to the specified function. See the
package vignette for further details.
\itemize{
\item \code{cg1} and \code{cg2} return a \code{cg_result} which is documented in the section
"Conjugate Gradient".
\item \code{bfgs1} and \code{bfgs2} return a \code{bfgs_result} which is documented in the
section "BFGS".
\item \code{lbfgsb1} and \code{lbfgsb2} return a \code{lbfgsb_result} which is documented in
the section "L-BFGS-B".
\item \code{neldermead} returns a \code{neldermead_result} which is documented in
the section "Nelder-Mead".
\item \code{nlm1}, \code{nlm2}, and \code{nlm3} return a \code{nlm_result} which is documented in
the section "Newton-Type Algorithm for Nonlinear Optimization".
}
}
\description{
Multivariate Optimization
}
\details{
The argument \code{args} should be a list constructed from one of the following
functions:
\itemize{
\item \code{bfgs_args} for BFGS;
\item \code{lbfgsb_args} for L-BFGS-B;
\item \code{cg_args} for CG;
\item \code{neldermead_args} for Nelder-Mead;
\item \code{nlm_args} for the Newton-type algorithm used in \code{nlm}.
}

When \code{g} or \code{h} are omitted, the gradient or Hessian will be respectively
be computed via finite differences.
}
\examples{
f = function(x) { sum(x^2) }
g = function(x) { 2*x }
h = function(x) { 2*diag(length(x)) }
x0 = c(1,1)

args = cg_args()
cg1(x0, f, g, args)
cg2(x0, f, args)

args = bfgs_args()
bfgs1(x0, f, g, args)
bfgs2(x0, f, args)

args = lbfgsb_args()
lbfgsb1(x0, f, g, args)
lbfgsb2(x0, f, args)

args = neldermead_args()
neldermead(x0, f, args)

args = nlm_args()
nlm1(x0, f, g, h, args)
nlm2(x0, f, g, args)
nlm3(x0, f, args)

}
