% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_importance_ranger.R
\name{extract_importance_ranger}
\alias{extract_importance_ranger}
\title{Extract the learner-specific importance from a ranger object}
\usage{
extract_importance_ranger(fit = NULL, feature_names = "", coef = 0)
}
\arguments{
\item{fit}{the \code{ranger} object.}

\item{feature_names}{the feature names}

\item{coef}{the Super Learner coefficient associated with the learner.}
}
\value{
a tibble, with columns \code{algorithm} (the fitted algorithm),
\code{feature} (the feature), \code{importance} (the algorithm-specific
extrinsic importance of the feature), \code{rank} (the feature importance
rank, with 1 indicating the most important feature), and \code{weight}
(the algorithm's weight in the Super Learner)
}
\description{
Extract the individual-algorithm extrinsic importance from a ranger object,
along with the importance rank.
}
\examples{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# get the fit
set.seed(20231129)
fit <- ranger::ranger(y ~ ., data = data.frame(y = y, x), importance = "impurity")
# extract importance
importance <- extract_importance_ranger(fit = fit, feature_names = feature_nms)
importance

}
