% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{coeftable.fixest_multi}
\alias{coeftable.fixest_multi}
\alias{se.fixest_multi}
\alias{tstat.fixest_multi}
\alias{pvalue.fixest_multi}
\title{Extracts the coefficients tables from \code{fixest_multi} estimations}
\usage{
\method{coeftable}{fixest_multi}(
  object,
  vcov = NULL,
  keep = NULL,
  drop = NULL,
  order = NULL,
  long = FALSE,
  wide = FALSE,
  ...
)

\method{se}{fixest_multi}(
  object,
  vcov = NULL,
  keep = NULL,
  drop = NULL,
  order = NULL,
  long = FALSE,
  ...
)

\method{tstat}{fixest_multi}(
  object,
  vcov = NULL,
  keep = NULL,
  drop = NULL,
  order = NULL,
  long = FALSE,
  ...
)

\method{pvalue}{fixest_multi}(
  object,
  vcov = NULL,
  keep = NULL,
  drop = NULL,
  order = NULL,
  long = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{fixest_multi} object, coming from a \code{fixest} multiple estimation.}

\item{vcov}{A function to be used to compute the standard-errors of each fixest object. You can pass extra arguments to this function using the argument \code{.vcov_args}. See the example.}

\item{keep}{Character vector. This element is used to display only a subset of variables. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). Each variable satisfying any of the regular expressions will be kept. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is kept). See details.}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). Each variable satisfying any of the regular expressions will be discarded. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \verb{drop = "x[[:digit:]]\{2\}}". If the first character is an exclamation mark, the effect is reversed (e.g. drop = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is dropped). See details.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions. This argument is applied post aliasing (see argument \code{dict}). Example: you have the following variables: \code{month1} to \code{month6}, then \code{x1} to \code{x5}, then \code{year1} to \code{year6}. If you want to display first the x's, then the years, then the months you could use: \code{order = c("x", "year")}. If the first character is an exclamation mark, the effect is reversed (e.g. order = "!Intercept" means: every variable that does not contain \dQuote{Intercept} goes first).  See details.}

\item{long}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, then all the information is stacked, with two columns containing the information: \code{"param"} and \code{"value"}. The column \code{param} contains the values \code{coef}/\code{se}/\code{tstat}/\code{pvalue}.}

\item{wide}{A logical scalar, default is \code{FALSE}. If \code{TRUE}, then a list is returned: the elements of the list are coef/se/tstat/pvalue. Each element of the list is a wide table with a column per coefficient.}

\item{...}{Other arguments to be passed to \code{\link{summary.fixest}}.}
}
\value{
It returns a \code{data.frame} containing the coefficients tables (or just the se/pvalue/tstat) along with the information on which model was estimated.

If \code{wide = TRUE}, then a list is returned. The elements of the list are coef/se/tstat/pvalue. Each element of the list is a wide table with a column per coefficient.

If \code{long = TRUE}, then all the information is stacked. This removes the 4 columns containing the coefficient estimates to the p-values, and replace them with two new columns: \code{"param"} and \code{"value"}. The column \code{param} contains the values \code{coef}/\code{se}/\code{tstat}/\code{pvalue}, and the column \code{values} the associated numerical information.
}
\description{
Series of methods to extract the coefficients table or its sub-components from a \code{fixest_multi} objects (i.e. the outcome of multiple estimations).
}
\section{Functions}{
\itemize{
\item \code{se.fixest_multi}: Extracts the standard-errors from \code{fixest_multi} estimations

\item \code{tstat.fixest_multi}: Extracts the t-stats from \code{fixest_multi} estimations

\item \code{pvalue.fixest_multi}: Extracts the p-values from \code{fixest_multi} estimations
}}

\examples{

base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
est_multi = feols(y~ csw(x.[,1:3]), base, split = ~species)

# we get all the coefficient tables at once
coeftable(est_multi)

# Now just the standard-errors
se(est_multi)

# wide = TRUE => leads toa  list of wide tables
coeftable(est_multi, wide = TRUE)

# long = TRUE, all the information is stacked
coeftable(est_multi, long = TRUE)



}
