% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected-graph-admm.R
\name{learn_connected_graph}
\alias{learn_connected_graph}
\title{Laplacian matrix of a connected graph with Gaussian data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Gaussian distributed.}
\usage{
learn_connected_graph(
  S,
  w0 = "naive",
  d = 1,
  rho = 1,
  maxiter = 10000,
  reltol = 1e-05,
  verbose = TRUE
)
}
\arguments{
\item{S}{a p x p covariance matrix, where p is the number of nodes in the graph}

\item{w0}{initial vector of graph weights. Either a vector of length p(p-1)/2 or
a string indicating the method to compute an initial value.}

\item{d}{the nodes' degrees. Either a vector or a single value.}

\item{rho}{constraint relaxation hyperparameter.}

\item{maxiter}{maximum number of iterations.}

\item{reltol}{relative tolerance as a convergence criteria.}

\item{verbose}{whether or not to show a progress bar during the iterations.}
}
\value{
A list containing possibly the following elements:
\item{\code{laplacian}}{estimated Laplacian matrix}
\item{\code{adjacency}}{estimated adjacency matrix}
\item{\code{theta}}{estimated Laplacian matrix slack variable}
\item{\code{maxiter}}{number of iterations taken to reach convergence}
\item{\code{convergence}}{boolean flag to indicate whether or not the optimization converged}
}
\description{
Laplacian matrix of a connected graph with Gaussian data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Gaussian distributed.
}
