% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findviews.R
\name{findviews_core}
\alias{findviews_core}
\title{Views of a multidimensional dataset, non-Shiny version}
\usage{
findviews_core(data, view_size_max = NULL, clust_method = "complete")
}
\arguments{
\item{data}{Data frame or matrix to be processed}

\item{view_size_max}{Maximum number of columns in the views. If set to
\code{NULL}, findviews uses \code{log2(ncol(data))}, rounded upwards and
capped at 5.}

\item{clust_method}{Character describing a clustering method, used internally
by \code{\link[stats]{hclust}}. Example values are "complete", "single" or
"average".}
}
\description{
\code{findviews_core} generates views of a multidimensional data set. It
produces the same results as \code{\link{findviews}}, but does
\emph{not} present them with a Shiny app.
}
\details{
\code{findviews_core} takes a data frame or a matrix as input. It computes the
pairwise dependency between the columns and detects clusters in the resulting
structure. See the documentation of \code{\link{findviews}} for more
details.

The  difference between \code{\link{findviews}} and
\code{\link{findviews_core}} is that the former presents its results
with a Shiny app, while the latter simply outputs them as R stuctures.
}
\examples{
\dontrun{
findviews_core(mtcars)
findviews_core(mtcars, view_size_max = 4)
}

}

