% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\name{fhir_next_bundle_url}
\alias{fhir_next_bundle_url}
\title{Next Bundle's URL}
\usage{
fhir_next_bundle_url(bundle = NULL)
}
\arguments{
\item{bundle}{The bundle from which you wish to extract the next link. If this is \code{NULL} (the default), the function will
extract the next link from the last bundle that was downloaded in the most recent call to \code{\link[=fhir_search]{fhir_search()}}.}
}
\value{
A \linkS4class{fhir_url} object referencing next bundle available on the FHIR server.
Empty \linkS4class{fhir_url} / character vector, if no further bundle is available.
}
\description{
fhir_next_bundle_url() gives the link to the next available bundle, either of the bundle
you provided in the argument \code{bundle} or of the last call to \code{\link[=fhir_search]{fhir_search()}}, if \code{bundle=NULL} (the default).

This function is useful when you don't have a lot of memory available or when a download of bundles was
interrupted for some reason. In case of small memory, you can use \code{fhir_next_bundle_url} together with the
\code{max_bundle} argument from \code{\link[=fhir_search]{fhir_search()}} to download bundles in smaller batches in a loop.
See details in the example.
}
\examples{
\donttest{
# workflow for small memory environments, downloading small batches of bundles
# for really small memory environments consider also using the `_count` option in
# your FHIR search request.
# You can iteratively download, crack and save the bundles until all bundles are processed or the
# desired number of bundles is reached.
url <- fhir_url("https://server.fire.ly/Patient")
count <- 0
obs <- fhir_table_description(resource = "Patient")
design <- fhir_design(obs)
while(length(url)>0 && count < 5){
	 bundles <- fhir_search(url, max_bundles = 2)
	 tables <- fhir_crack(bundles, design)
  save(tables, file = paste0(tempdir(),"/table_", count, ".RData"))
  count <- count + 1
  url <- fhir_next_bundle_url()
}
#you can see the saved tables here:
dir(tempdir())
}

}
