% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{data}
\name{example_bundles1}
\alias{example_bundles1}
\alias{example_bundles2}
\alias{example_bundles3}
\alias{example_bundles4}
\title{Toy example bundles for multiple entries}
\format{
An object of class \code{fhir_bundle_list} of length 1.

An object of class \code{fhir_bundle_list} of length 1.

An object of class \code{fhir_bundle_list} of length 1.

An object of class \code{fhir_bundle_list} of length 1.
}
\source{
\strong{example_bundles1}

\if{html}{\out{<div class="sourceCode">}}\preformatted{<Bundle>
 <type value='searchset'/>
 <entry>
  <resource>
    <Patient>
       <id value='id1'/>
	      <address>
	         <use value='home'/>
	         <city value='Amsterdam'/>
	         <type value='physical'/>
	         <country value='Netherlands'/>
	      </address>
	      <name>
	         <given value='Marie'/>
	      </name>
    </Patient>
  </resource>
 </entry>

 <entry>
  <resource>
    <Patient>
       <id value='id3'/>
	      <address>
	         <use value='home'/>
	         <city value='Berlin'/>
	      </address>
       <address>
          <type value='postal'/>
          <country value='France'/>
       </address>
	      <address>
	         <use value='work'/>
	         <city value='London'/>
	         <type value='postal'/>
	         <country value='England'/>
	      </address>
       <name>
          <given value='Frank'/>
       </name>
       <name>
          <given value='Max'/>
       </name>
    </Patient>
  </resource>
 </entry>
</Bundle>
}\if{html}{\out{</div>}}

\strong{example_bundles2}

\if{html}{\out{<div class="sourceCode">}}\preformatted{<Bundle>
 <type value='searchset'/>
 <entry>
  <resource>
     <Patient>
        <id value='id1'/>
        <address>
           <use value='home'/>
           <city value='Amsterdam'/>
           <type value='physical'/>
           <country value='Netherlands'/>
        </address>
        <name>
           <given value='Marie'/>
        </name>
     </Patient>
   </resource>
 </entry>

 <entry>
  <resource>
    <Patient>
        <id value='id2'/>
        <address>
           <use value='home'/>
           <city value='Rome'/>
           <type value='physical'/>
           <country value='Italy'/>
        </address>
        <address>
           <use value='work'/>
           <city value='Stockholm'/>
	          <type value='postal'/>
           <country value='Sweden'/>
        </address>
        <name>
           <given value='Susie'/>
       </name>
    </Patient>
  </resource>
 </entry>

 <entry>
  <resource>
    <Patient>
       <id value='id3'/>
       <address>
          <use value='home'/>
          <city value='Berlin'/>
       </address>
       <address>
          <type value='postal'/>
          <country value='France'/>
       </address>
       <address>
          <use value='work'/>
          <city value='London'/>
          <type value='postal'/>
          <country value='England'/>
       </address>
       <name>
          <given value='Frank'/>
      </name>
      <name>
          <given value='Max'/>
       </name>
    </Patient>
  </resource>
 </entry>
</Bundle>
}\if{html}{\out{</div>}}

\strong{example_bundles3}

\if{html}{\out{<div class="sourceCode">}}\preformatted{<Bundle>
 <type value='searchset'/>
 <entry>
  <resource>
    <Patient>
       <id value='id1'/>
       <address>
          <use value='home'/>
          <city value='Amsterdam'/>
          <type value='physical'/>
          <country value='Netherlands'/>
       </address>
       <name>
          <given value='Marie'/>
       </name>
    </Patient>
  </resource>
 </entry>

 <entry>
  <resource>
    <Patient>
       <id value='id2'/>
       <address>
          <use value='home'/>
          <city value='Rome'/>
          <type value='physical'/>
          <country value='Italy'/>
       </address>
       <address>
          <use value='work'/>
          <city value='Stockholm'/>
          <type value='postal'/>
          <country value='Sweden'/>
       </address>
       <name>
          <given value='Susie'/>
       </name>
    </Patient>
  </resource>
 </entry>

 <entry>
  <resource>
    <Patient>
       <id value='id3'/>
       <address>
          <use value='home'/>
          <city value='Berlin'/>
       </address>
       <address>
          <type value='postal'/>
          <country value='France'/>
       </address>
       <address>
          <use value='work'/>
          <city value='London'/>
          <type value='postal'/>
          <country value='England'/>
       </address>
       <name>
          <given value='Frank'/>
       </name>
       <name>
          <given value='Max'/>
       </name>
    </Patient>
  <resource/>
 </entry>

 <entry>
  <resource>
    <Observation>
       <id value = 'obs1'/>
       <code>
          <coding>
             <system value='http://loinc.org'/>
             <code value='29463-7'/>
             <display value='Body Weight'/>
          </coding>
          <coding>
             <system value='http://snomed.info/sct'/>
             <code value='27113001'/>
             <display value='Body weight'/>
          </coding>
       </code>
       <subject>
          <reference value='Patient/id3'/>
       </subject>
    </Observation>
  </resource>
 </entry>
</Bundle>"

}\if{html}{\out{</div>}}

\strong{example_bundles4}

\if{html}{\out{<div class="sourceCode">}}\preformatted{<Bundle>
    <type value='searchset'/>
 <entry>
	 <resource>
		<Medication>
		    <id value='1285'/>
		    <code>
		        <coding>
		            <system value='http://www.nlm.nih.gov/research/umls/rxnorm'/>
		            <code value='1594660'/>
		            <display value='Alemtuzumab 10mg/ml (Lemtrada)'/>
		        </coding>
		    </code>
		    <ingredient id='1'>
		    	<itemReference>
	        		<reference value='Substance/5463'/>
	    		</itemReference>
		    </ingredient>
		    <ingredient id='2'>
		    	<itemReference>
	        		<reference value='Substance/3401'/>
	    		</itemReference>
		    </ingredient>
		</Medication>
	</resource>
 </entry>

 <entry>
	 <resource>
         <Medication>
             <id value='45226'/>
             <code>
                 <coding>
                     <system value='http://snomed.info/sct'/>
                     <code value='373994007'/>
                     <display value='Prednisone 5mg tablet (Product)'/>
                 </coding>
                 <text value='Prednisone 5mg tablet (Product)'/>
             </code>
		    <ingredient id='1'>
		    	<itemReference>
	        		<reference value='Substance/6912'/>
	    		</itemReference>
		    </ingredient>
		    <ingredient id='2'>
		    	<itemReference>
	        		<reference value='Substance/3710'/>
	    		</itemReference>
		    </ingredient>
		</Medication>
	</resource>
 </entry>

</Bundle>

}\if{html}{\out{</div>}}
}
\usage{
example_bundles1

example_bundles2

example_bundles3

example_bundles4
}
\description{
These data examples are bundles that contain very few very simple Patient resources
that have multiple entries and can be used for demonstration purposes. See \strong{Source} for how the
xml versions look.
}
\details{
\code{example_bundles1} contains 1 bundle with 2 Patient resources.

\code{example_bundles2} contains 1 bundle with 3 Patient resources.

\code{example_bundles3} contains 1 bundle with 3 Patient resources and 1 Observation resource.

\code{example_bundles4} contains 1 bundle with 2 Medication resources, one of which has some \verb{@id} xml attributes
}
\examples{
#unserialize xml objects before doing anything else with them!
fhir_unserialize(bundles = example_bundles1)
#unserialize xml objects before doing anything else with them!
fhir_unserialize(example_bundles2)
#unserialize xml objects before doing anything else with them!
fhir_unserialize(bundles = example_bundles3)
#unserialize xml objects before doing anything else with them!
fhir_unserialize(bundles = example_bundles4)
}
\keyword{datasets}
