% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-nsffa-fit.R
\name{plot_nsffa_fit}
\alias{plot_nsffa_fit}
\title{Plot Fitted Probability Distributions for NS-FFA}
\usage{
plot_nsffa_fit(
  results,
  slices = c(1925, 1950, 1975, 2000),
  show_line = TRUE,
  ...
)
}
\arguments{
\item{results}{A fitted flood frequency model generated by \code{\link[=fit_lmoments]{fit_lmoments()}},
\code{\link[=fit_mle]{fit_mle()}} or \code{\link[=fit_gmle]{fit_gmle()}}.}

\item{slices}{Years at which to plot the nonstationary probability model.}

\item{show_line}{If \code{TRUE} (default), draw a fitted line through the data.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot showing:
\itemize{
\item The likelihood function of the distribution plotted vertically on the left panel.
\item The data, connected with a line if \code{show_line == TRUE}, on the right panel.
}
}
\description{
Generates a plot showing probability densities of a nonstationary model for selected
time slices (left panel) and the data (right panel).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10) + seq(1, 100)
years <- seq(from = 1901, to = 2000)
ns_structure <- list(location = TRUE, scale = FALSE)

results <- fit_mle(
	   data, 
	   "GEV", 
	   ns_years = years, 
	   ns_structure = ns_structure
)

plot_nsffa_fit(results)

}
