% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtn.R
\name{make_rtn}
\alias{make_rtn}
\title{Create a Return Object}
\usage{
make_rtn(date, mv, pl, id = 1L)
}
\arguments{
\item{date}{a Date vector, the reference date of each row}

\item{mv, pl}{a double vector, the market value and the 'PnL' (Profit and Loss) of each day}

\item{id}{an integer vector, the ID of each row belongs to}
}
\value{
A list of functions, with signature of \code{from}, \code{to} and \code{id}, all of
which are only allowed to accept a scalar. They all return an \code{xts} object
with one column.
\itemize{
\item \code{twrr_cr}: the cumulative Time-weighted Return
\item \code{twrr_dr}: the daily Time-weighted Return
\item \code{dietz}: the Modified Dietz Return
\item \code{dietz_avc}: the denominator used to calculate the 'Modifie Dietz Return
\item \code{cum_pl}: the cumulative PnL
}
}
\description{
By providing a "group" (\code{ids}) of \code{dates}, \code{mvs} and \code{pls},
calucating the Time-weighted Rate of Return (TWRR) or Modified
Dietz Rate of Return (DIETZ).
}
\note{
All the input vector must be 1 or the same length.
}
\section{Cash flow handling}{

\itemize{
\item The cash flow is not provided externally. Instead, it's deducted via
market value and PnL, with the equation \eqn{\Delta MV = \Delta PnL + CF}.
\item The cash inflow is treating as if it happens at the beginning of the day,
while the cash outflow is at the end of the day. The reasons are two.
The first is to reduce the possibility of having a close-to-zero denominator.
The second is the cash is usually not usable for the whole day.
\item The calculation is based on calendar days. No business calendar or weekday
considers. You can't change the calculation frequency, either. However,
this is possible in the future version.
}
}

\examples{
rtn <- make_rtn(date = c(210101, 210105, 210110), mv = c(100, 123, 140), pl = c(0, 3, 7))
rtn$twrr_cr(210102, 210110)
rtn$twrr_dr(210102, 210110)
rtn$dietz(210102, 210110)
rtn$dietz_avc(210102, 210110)
}
\references{
Modified Dietz Method: https://en.wikipedia.org/wiki/Modified_Dietz_method

Time weighed Return: https://en.wikipedia.org/wiki/Time-weighted_return
}
