% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.r
\name{init,GRaster-method}
\alias{init,GRaster-method}
\alias{init}
\title{GRaster with values equal to row, column, coordinate, regular, or "chess"}
\usage{
\S4method{init}{GRaster}(x, fun, odd = TRUE, vals = c(0, 1))
}
\arguments{
\item{x}{A \code{GRaster} to be used as a template.}

\item{fun}{Character: Any of:
\itemize{
\item \code{"x"} or \code{"y"}: Cell longitude or latitude
\item \code{"row"} or \code{"col"}: Cell row or column
\item \code{"chess"}: Alternating values.
\item \code{"regular"}: Evenly-spaced cells with the same value.
}}

\item{odd}{Logical: If \code{TRUE} (default), and \code{fun} is \code{"chess"}, then the top left cell in the raster will be a "negative" cell. If \code{FALSE}, then the top left cell with be "positive".}

\item{vals}{Vector of two numeric values: If \code{fun} is \code{"chess"} or \code{"regular"}, then assign the first value to "positive" cells and the second value to "negative" cells. The default is \code{c(1, 0)}}
}
\value{
A \code{GRaster} with as many layers as \code{x}.
}
\description{
This function can be used to make a \code{GRaster} with cell values equal to the cell center's longitude, latitude, row, or column, or in a "chess"-like or "regular" pattern.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster, rivers vector
madElev <- fastData("madElev")

# Convert to a GRaster
elev <- fast(madElev)

# Cell coordinates
init(elev, "x")
init(elev, "y")

# Cell row or column
init(elev, "row")
init(elev, "col")

# Chess
elevAgg <- aggregate(elev, 32) # make cells bigger so we can see them

chessOdd <- init(elevAgg, "chess")
chessEven <- init(elevAgg, "chess", odd = FALSE)

chess <- c(chessOdd, chessEven)
names(chess) <- c("odd", "even")
plot(chess)

# Chess with user-defined values
elevAgg <- aggregate(elev, 32) # make cells bigger so we can see

chessOdd13 <- init(elevAgg, "chess", vals = c(0, 13))
chessEven13 <- init(elevAgg, "chess", odd = FALSE, vals = c(0, 13))

chess13 <- c(chessOdd13, chessEven13)
names(chess13) <- c("odd", "even")
plot(chess13)

# Regular
elevAgg <- aggregate(elev, 32) # make cells bigger so we can see

regOdd <- init(elevAgg, "regular")
regEven <- init(elevAgg, "regular", odd = FALSE)

reg <- c(regOdd, regEven)
names(reg) <- c("odd", "even")
plot(reg)

}
}
\seealso{
\code{\link[terra:init]{terra::init()}}, \code{\link[=longlat]{longlat()}}
}
