% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasi.R
\name{predict.fasi}
\alias{predict.fasi}
\title{Prediction of a FASI Object}
\usage{
\method{predict}{fasi}(
  object,
  test_data,
  alpha_1,
  alpha_2,
  rscore_plus = TRUE,
  ptd_group_var = "a",
  class_label = "y",
  ranking_score_calibrate,
  ranking_score_test,
  indecision_choice = "2",
  ...
)
}
\arguments{
\item{object}{An object of class fasi. It can be created from the fasi function.}

\item{test_data}{The test data set that contains new observations to be classified.}

\item{alpha_1}{User specified group and overall FSR control for class 1.}

\item{alpha_2}{User specified group and overall FSR control for class 2.}

\item{rscore_plus}{A logical variable that indicates if the r-score or r-score plus is calculated. By default the r-score plus is calculated.}

\item{ptd_group_var}{The name of the protected group variable in your data set. Defaults to "a".}

\item{class_label}{The name of the class label variable in your data set. Defaults to "y".}

\item{ranking_score_calibrate}{A vector of ranking scores for the calibration data set. This should only be used if the built in ranking score algorithms are not used.}

\item{ranking_score_test}{A vector of ranking scores for the test data set. This should only be used if the built in ranking score algorithms are not used.}

\item{indecision_choice}{A number, 1, 2, or 3. This determines how the indecision cases are treated if we are equally confident in placing them in both class 1 and 2. Defaults to the scenario where class 2 is preferred}

\item{...}{Additional arguments}
}
\value{
A list where the first element is the r-scores for both class 1 and class 2. The second element is the actual classifications, class 1, class 2 or the indecision class. The third element is a logical value True/False that denotes if the r-score or r-score plus was calculated. The last element in the list is the values of alpha for both classes. Alpha can directly be compared to the r-scores to obtain the classifications.
}
\description{
After a model is trained with the fasi function, predict estimates the r-scores and classification of all observations in the test data set.
}
\examples{
\donttest{
fasi_object <- fasi(observed_data, model_formula, split_p=0.5, alg="gam", class_label="y")
predict(fasi_object, test_data, alpha_1=0.1, alpha_2=0.1)
}
}
\author{
Bradley Rava. PhD Candidate at the University of Southern California's Marshall School of Business.
Department of Data Sciences and Operations.
}
