% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationSampleSimilarity.R
\name{export_sample_similarity}
\alias{export_sample_similarity}
\alias{export_sample_similarity,familiarCollection-method}
\alias{export_sample_similarity,ANY-method}
\title{Extract and export mutual correlation between features.}
\usage{
export_sample_similarity(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  sample_limit = waiver(),
  sample_cluster_method = waiver(),
  sample_linkage_method = waiver(),
  export_dendrogram = FALSE,
  export_collection = FALSE,
  ...
)

\S4method{export_sample_similarity}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  sample_limit = waiver(),
  sample_cluster_method = waiver(),
  sample_linkage_method = waiver(),
  export_dendrogram = FALSE,
  export_collection = FALSE,
  ...
)

\S4method{export_sample_similarity}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  sample_limit = waiver(),
  sample_cluster_method = waiver(),
  sample_linkage_method = waiver(),
  export_dendrogram = FALSE,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{sample_limit}{(\emph{optional}) Set the upper limit of the number of samples
that are used during evaluation steps. Cannot be less than 20.

This setting can be specified per data element by providing a parameter
value in a named list with data elements, e.g.
\code{list("sample_similarity"=100, "permutation_vimp"=1000)}.

This parameter can be set for the following data elements:
\code{sample_similarity} and \code{ice_data}.}

\item{sample_cluster_method}{The method used to perform clustering based on
distance between samples. These are the same methods as for the
\code{cluster_method} configuration parameter: \code{hclust}, \code{agnes}, \code{diana} and
\code{pam}.

\code{none} cannot be used when extracting data for feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{export_dendrogram}{Add dendrogram in the data element objects.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object} parameter
is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A list containing a data.table (if \code{dir_path} is not provided), or
nothing, as all data is exported to \code{csv} files.
}
\description{
Extract and export mutual correlation between features in a
familiarCollection.
}
\details{
Data is usually collected from a \code{familiarCollection} object.
However, you can also provide one or more \code{familiarData} objects, that will
be internally converted to a \code{familiarCollection} object. It is also
possible to provide a \code{familiarEnsemble} or one or more \code{familiarModel}
objects together with the data from which data is computed prior to export.
Paths to the previous files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.
}
