% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataParameterChecks.R
\name{.check_input_identifier_column}
\alias{.check_input_identifier_column}
\title{Internal function for checking consistency of the identifier columns}
\usage{
.check_input_identifier_column(
  id_column,
  data,
  signature = NULL,
  exclude_features = NULL,
  include_features = NULL,
  other_id_column = NULL,
  outcome_column = NULL,
  col_type,
  check_stringency = "strict"
)
}
\arguments{
\item{id_column}{Character string indicating the currently inspected
identifier column.}

\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{signature}{(\emph{optional}) One or more names of feature columns that are
considered part of a specific signature. Features specified here will
always be used for modelling. Ranking from feature selection has no effect
for these features.}

\item{exclude_features}{(\emph{optional}) Feature columns that will be removed
from the data set. Cannot overlap with features in \code{signature},
\code{novelty_features} or \code{include_features}.}

\item{include_features}{(\emph{optional}) Feature columns that are specifically
included in the data set. By default all features are included. Cannot
overlap with \code{exclude_features}, but may overlap \code{signature}. Features in
\code{signature} and \code{novelty_features} are always included. If both
\code{exclude_features} and \code{include_features} are provided, \code{include_features}
takes precedence, provided that there is no overlap between the two.}

\item{other_id_column}{Character string indicating another identifier column.}

\item{outcome_column}{Character string indicating the outcome column(s).}

\item{col_type}{Character string indicating the type of column, i.e. \code{sample}
or \code{batch}.}

\item{check_stringency}{Specifies stringency of various checks. This is mostly:
\itemize{
\item \code{strict}: default value used for \code{summon_familiar}. Thoroughly checks
input data. Used internally for checking development data.
\item \code{external_warn}: value used for \code{extract_data} and related methods. Less
stringent checks, but will warn for possible issues. Used internally for
checking data for evaluation and explanation.
\item \code{external}: value used for external methods such as \code{predict}. Less
stringent checks, particularly for identifier and outcome columns, which may
be completely absent. Used internally for \code{predict}.
}}
}
\description{
This function checks whether an identifier column is consistent, i.e. appears
it exists, there is only one, and there is no overlap with any user-provided
feature columns, identifiers, or
}
\keyword{internal}
