% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.fairness_radar}
\alias{print.fairness_radar}
\title{Print fairness radar}
\usage{
\method{print}{fairness_radar}(x, ...)
}
\arguments{
\item{x}{\code{fairness_radar} object}

\item{...}{other print parameters}
}
\description{
Print fairness radar
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")


fradar <- fairness_radar(fobject)

print(fradar)

}
