% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_targetpct}
\alias{explore_targetpct}
\title{Explore variable + binary target (values 0/1)}
\usage{
explore_targetpct(
  data,
  var,
  target = NULL,
  title = NULL,
  min_val = NA,
  max_val = NA,
  auto_scale = TRUE,
  na = NA,
  flip = NA,
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{var}{Numerical variable}

\item{target}{Target variable (0/1 or FALSE/TRUE)}

\item{title}{Title of the plot}

\item{min_val}{All values < min_val are converted to min_val}

\item{max_val}{All values > max_val are converted to max_val}

\item{auto_scale}{Use 0.2 and 0.98 quantile for min_val and max_val (if min_val and max_val are not defined)}

\item{na}{Value to replace NA}

\item{flip}{Flip plot? (for categorical variables)}

\item{...}{Further arguments}
}
\value{
Plot object
}
\description{
Create a plot to explore relation between a variable and a binary target
as target percent. The target variable is choosen automatically
if possible (name starts with 'target')
}
\examples{
iris$target01 <- ifelse(iris$Species == "versicolor",1,0)
explore_targetpct(iris)
}
