% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download various evapotranspiration data products}
\usage{
download_data(
  data_name = "all",
  path = "",
  domain = "raw",
  time_res = "monthly"
)
}
\arguments{
\item{data_name}{a character string with the name(s) of the desired data set. Suitable options are:
\itemize{
\item{"all" for all of the below listed data sets (default),}
\item{"bess" for BESS,}
\item{"camele" for CAMELE,}
\item{"era5" for ERA5,}
\item{"era5-land" for ERA5-Land,}
\item{"fldas" for FLDAS,} 
\item{"gldas-clsm" for GLDAS CLSM,}
\item{"gldas-noah" for GLDAS NOAH,}
\item{"gldas-vic" for GLDAS VIC,}
\item{"gleam" for GLEAM V3,}
\item{"jra-55" for JRA-55,}
\item{"merra-2" for MERRA-2,}
\item{"terraclimate" for TerraClimate,}
\item{"zheng" for Zheng,}
}}

\item{path}{a character string with the path where the database will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean", for data sets with ocean only coverage.}
}}

\item{time_res}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly".}
}}
}
\value{
No return value, called to download the required data sets.
}
\description{
The function \code{download_data} downloads the selected data product.
}
\examples{
\donttest{
download_data("gldas-vic", tempdir())
}
}
