% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdf_plot.R
\name{ecdf_plot}
\alias{ecdf_plot}
\title{Empirical Cumulative Distribution Plot}
\usage{
ecdf_plot(formula, data, ref_cut = NULL, hor_ref = FALSE, rect_ref = TRUE,
  legend = "side", theme = NULL, annotate = FALSE, ...)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_cut}{Optional numeric vector stating the location of reference 
line(s) and/or rectangle(s).}

\item{hor_ref}{Logical, defaults to \code{FALSE}. Should horizontal
reference lines be plotted at the location of \code{ref_cut}?}

\item{rect_ref}{Logical, defaults to \code{TRUE}. Should semi-transparent 
rectangle(s) be plotted at the locations of \code{ref_cut}?}

\item{legend}{The type of legend to be displayed, with possible values 
\code{"base"}, \code{"side"}, or \code{"none"}. Defaults to \code{"side"}, 
when there are more than two groups and \code{"none"} when only comparing
two groups. If the option \code{"side"} is used the plot is split into two
plots, via \link[graphics]{layout}, with the legend displayed in the second 
plot. This scales better than the base legend (i.e., manually manipulating
the size of the plot after it is rendered), but is not compatible with 
multi-panel plotting (e.g., \code{par(mfrow = c(2, 2))} for a 2 by 2 plot).
When producing multi-panel plots, use \code{"none"} or \code{"base"}, the
latter of which produces the legend with the base \link[graphics]{legend}
function.}

\item{theme}{Visual properties of the plot. There are currently only two
themes implemented - a standard plot and a dark theme. If \code{NULL} 
(default), the theme will be produced with a standard white background. If
\code{"dark"}, a dark gray background will be used with white text and axes.}

\item{annotate}{Logical. Defaults to \code{FALSE}. When \code{TRUE} and 
\code{legend == "side"} the plot is rendered such that additional
annotations can be made on the plot using low level base plotting functions
(e.g., \link[graphics]{arrows}). However, if set to \code{TRUE}, 
\link[grDevices]{dev.off} must be called before a new plot is rendered 
(i.e., close the current plotting window). Otherwise the plot will be
attempted to be rendered in the region designated for the legend. Argument
is ignored when \code{legend != "side"}.}

\item{...}{Additional arguments passed to \link[graphics]{plot}. Note that
it is best to use the full argument rather than partial matching, given the
method used to call the plot. While some partial matching is supported 
(e.g., \code{m} for \code{main}, it is generally safest to supply the full
argument).}
}
\description{
This function dresses up the \link[stats]{plot.ecdf} function and provides
some additional functionality to directly compare distributions at specific
locations along the scale. Specifically, multiple empirical CDFs can be 
plotted with a single call, and the differences between any pair, or all, 
CDFs can optionally be plotted in terms of both raw percentage differences 
and/or in terms of standard deviation units through inverse normal
transformations. See 
\href{http://journals.sagepub.com/doi/abs/10.3102/1076998611411918}{Ho &
 Reardon, 2012}. (Note, not all features implemented yet)
}
\examples{
# Produce base empirical cummulative distribution plot
ecdf_plot(mean ~ grade, seda)

# Shade distributions to the right of three cut scores
ecdf_plot(mean ~ grade, 
		seda,
		ref_cut = c(225, 245, 265))

# Add horizontal reference lines
ecdf_plot(mean ~ grade, 
		seda,
		ref_cut = c(225, 245, 265),
		hor_ref = TRUE)

# Apply dark theme
ecdf_plot(mean ~ grade, 
		seda,
		ref_cut = c(225, 245, 265),
		theme = "dark")
}
