% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED1_SSR.sim}
\alias{AED1_SSR.sim}
\title{Conduct the simulation studies of the Adaptive Enrichment Design
  (Strategy 1) with Sample Size Re-estimation Procedure}
\usage{
AED1_SSR.sim(N1, rho, alpha, beta, pstar, theta, theta0, Info, K = 2,
  epsilon, sigma0, nSim, Seed)
}
\arguments{
\item{N1}{The sample size used at the first stage}

\item{rho}{The proportion of subgroup 1 among the overall patients}

\item{alpha}{The overall Type I error rate}

\item{beta}{The (1 - Power)}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}

\item{theta}{The sizes of the treatment effect in subgroups 1 and 2 with the
experimental arm}

\item{theta0}{The size of the treatment effect in standard arm}

\item{Info}{The observation information}

\item{K}{The number of subgroups. The default value is \code{K = 2}}

\item{epsilon}{The threshold of the difference between the subgroup-specific
test statistic}

\item{sigma0}{The variance of the treatment effect}

\item{nSim}{The number of simulated studies}

\item{Seed}{The random seed}
}
\value{
A list contains
\itemize{
  \item nTotal The average expected sample size
  \item H00 The probability of rejecting the null hypothesis of \eqn{H_{00}}
  \item H01 The probability of rejecting the null hypothesis of \eqn{H_{01}}
  \item H02 The probability of rejecting the null hypothesis of \eqn{H_{02}}
  \item H0  The probabilities of rejecting at least one of the null hypothesis
  \item ESF The probability of early stopping for futility
  \item ESE The probability of early stopping for efficacy
  \item Enrich01 The prevalence of adaptive enrichment of subgroup 1
  \item Enrich02 The prevalence of adaptive enrichment of subgroup 2
}
}
\description{
The \code{AED1_SSR.sim()} is used to conduct the simulation study
  of the Adaptive Enrichment Design (Strategy 1) with Sample Size Re-estimation
  procedure
}
\examples{
res <- AED1_SSR.sim(
  N1 = 310, rho = 0.5,
  alpha = 0.05, beta = 0.2, pstar = 0.2,
  theta = c(0,0), theta0 = 0, Info = 0.5,
  epsilon = 0.5, sigma0 = 1, nSim = 1000, Seed = 6)
}
\references{
\itemize{
  \item Zhao Yang, Ruitao Lin, Guosheng Yin and Ying Yuan. (2018) Sample Size
    Re-estimation in Adaptive Enrichment Trials. (Under Preparation)
}
}
