% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idd.R
\name{use_idd}
\alias{use_idd}
\alias{download_idd}
\alias{avail_idd}
\alias{is_avail_idd}
\title{Use a specific EnergyPlus Input Data Dictionary (IDD) file}
\usage{
use_idd(idd, download = FALSE)

download_idd(ver = "latest", dir)

avail_idd()

is_avail_idd(ver)
}
\arguments{
\item{idd}{Either a path, a connection, or literal data (either a single
string or a raw vector) to an EnergyPlus Input Data Dictionary (IDD)
file, usually named as \code{Energy+.idd}, or a valid version of IDD, e.g.
\code{8.9}, \code{"8.9.0"}.}

\item{download}{If \code{TRUE} and argument \code{idd}, the IDD file will be
downloaded from \href{https://github.com/NREL/EnergyPlus}{EnergyPlus GitHub Repository},
and saved to \code{\link[=tempdir]{tempdir()}}. It will be parsed after it is downloaded
successfully. A special value of \code{"auto"} can be given, which will
automatically download corresponding IDD file if the Idd object is
currently not available. It is useful in case when you only want to edit
an EnergyPlus Input Data File (IDF) directly but do not want to install
whole EnergyPlus software. Default is \code{FALSE}.}

\item{ver}{A valid EnergyPlus version, e.g. \code{8}, \code{8.7}, \code{"8.7"} or \code{"8.7.0"}.
For \code{download_idd()}, the special value \code{"latest"}, which is default,
means the latest version.}

\item{dir}{A directory to indicate where to save the IDD file.}
}
\value{
\itemize{
\item \code{use_idd()} returns an \code{Idd} object
\item \code{download_idd()} returns an invisible integer \code{0} if succeed. Also an
attribute named \code{file} which is the full path of the downloaded IDD file;
\item \code{avail_idd()} returns a \link[base:numeric_version]{numeric_version} vector
or \code{NULL} if no available Idd object found.
\item \code{is_avail_idd()} returns a single logical vector.
}
}
\description{
Use a specific EnergyPlus Input Data Dictionary (IDD) file
}
\details{
\code{use_idd()} takes a valid version or a path of an EnergyPlus Input Data
Dictionary (IDD) file, usually named "Energy+.idd" and return an \code{Idd}
object. For details on \code{Idd} class, please see \link{Idd}.

\code{download_idd()} downloads specified version of EnergyPlus IDD file from
\href{https://github.com/NREL/EnergyPlus}{EnergyPlus GitHub Repository}. It is
useful in case where you only want to edit an EnergyPlus Input Data File
(IDF) directly but do not want to install whole EnergyPlus software.

\code{avail_idd()} returns versions of all cached \code{Idd} object.

\code{is_avail_idd()} returns \code{TRUE} if input version of IDD file has been parsed
and cached.

eplusr tries to detect all installed EnergyPlus in default installation
locations when loading. If argument \code{idd} is a version, eplusr will first try
to find the cached \code{Idd} object of that version, if possible. If failed, and
EnergyPlus of that version is available (see \code{\link[=avail_eplus]{avail_eplus()}}), the
\code{"Energy+.idd"} distributed with EnergyPlus will be parsed and stored in
eplusr Idd cache.
}
\examples{
\dontrun{
# get all available Idd version
avail_idd()

# check if specific version of Idd is available
is_avail_idd(8.5)

# download latest IDD file from EnergyPlus GitHub repo
download_idd("latest", tempdir())

# use specific version of Idd
# only works if EnergyPlus v8.8 has been found or Idd v8.8 exists
use_idd(8.8)

# If Idd object is currently not avail_idd, automatically download IDD file
# from EnergyPlus GitHub repo and parse it
use_idd(8.8, download = "auto")

# now Idd v8.8 should be available
is_avail_idd(8.8)

# get specific version of parsed Idd object
use_idd(8.8)

avail_idd() # should contain "8.8.0"
}
}
\seealso{
\link{Idd} Class for parsing, querying and making modifications to
EnergyPlus IDD file
}
\author{
Hongyuan Jia
}
