% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envvar_get.R
\name{envvar_get}
\alias{envvar_get}
\alias{envvar_get_oneof}
\title{Get the value of an environment variable}
\usage{
envvar_get(
  x,
  default = NULL,
  transform = NULL,
  validate = NULL,
  warn_default = TRUE
)

envvar_get_oneof(
  x,
  choices,
  default = NULL,
  transform = NULL,
  validate = NULL,
  warn_default = TRUE
)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{default}{Optional default value if the environment variable is not set}

\item{transform}{Optional function that applies a transformation to the
variable's value}

\item{validate}{Optional function that checks a value for validity}

\item{warn_default}{Show a warning if the default value is used
(default: \code{TRUE})}

\item{choices}{A list containing the potential values}
}
\value{
The value of the given environment variable, if set. This is a string
unless a \code{transform} function has changed the object's type.
}
\description{
\code{envvar_get()} returns the value of an environment variable.

\code{envvar_get_oneof()} gets the value of an environment variable
and ensures that it is within a defined set of potential values.
}
\details{
\code{envvar_get()} and the other type-specific variants follow this workflow:
\itemize{
\item The value of the environment variable is retrieved. If that variable is
not set and \code{default} non-NULL, the default value is used. Otherwise an error
is raised.
\item Optionally, the value can be transformed by a function specified by the
\code{transform} argument. Transformation functions return a scalar object.
\item Optionally, the value can be validated by a function specified by the
\code{validate} argument. Validation functions return a logical value indicating
whether or not the value matches the given criteria. An error is raised if
the validation function does not return \code{TRUE}.
\item The transformed, validated value is returned.
}
}
\examples{
# Get the current user's home directory
envvar_get("HOME")

# Get the current logging level for your app, ensuring it is a known value
envvar_set("LOG_LEVEL" = "DEBUG")
envvar_get_oneof(
  "LOG_LEVEL",
  choices = c("TRACE", "DEBUG", "INFO", "SUCCESS", "WARN", "ERROR", "FATAL")
)
}
