% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{joint_tests}
\alias{joint_tests}
\alias{make.meanint}
\alias{meanint}
\alias{make.symmint}
\alias{symmint}
\title{Compute joint tests of the terms in a model}
\usage{
joint_tests(object, by = NULL, show0df = FALSE, showconf = TRUE,
  cov.reduce = make.meanint(1), ...)

make.meanint(delta = 1, npts = 2)

meanint(x)

make.symmint(ctr, delta = 1, npts = 2)

symmint(ctr)
}
\arguments{
\item{object}{a fitted model, \code{emmGrid}, or \code{emm_list}. If the
latter, its first element is used.}

\item{by}{character names of \code{by} variables. Separate sets of tests are
run for each combination of these.}

\item{show0df}{logical value; if \code{TRUE}, results with zero numerator
degrees of freedom are displayed, if \code{FALSE} they are skipped}

\item{showconf}{logical value.
When we have models with estimability issues (e.g., missing cells), then with
\code{showconf = TRUE}, we test any remaining effects that are not purely
due to contrasts of a single term. If found, they are labeled
\code{(confounded)}. See
\code{vignette("xplanations")} for more information.}

\item{cov.reduce}{a function.
If \code{object} is a fitted model, it is
replaced by \code{ref_grid(object, cov.reduce = cov.reduce, ...)}.
For this purpose, the functions \code{meanint} and \code{symmint} are
available for returning an interval around the mean or around zero,
respectively. Se the section below on covariates.}

\item{...}{additional arguments passed to \code{ref_grid} and \code{emmeans}}

\item{delta, ctr}{arguments for \code{make.meanint} and \code{make.symmint}.
\code{delta} sets the distance each side of the center, so that the
width of the interval is \code{2*delta}.}

\item{npts}{number of points to include in the interval}

\item{x}{argument for \code{meanint} and \code{symmint}}
}
\value{
a \code{summary_emm} object (same as is produced by 
  \code{\link{summary.emmGrid}}). All effects for which there are no
  estimable contrasts are omitted from the results. 
  There may be an additional row named \code{(confounded)} which accounts
  for additional degrees of freedom for effects not accounted for in the 
  preceding rows.
  
  The returned object also includes an \code{"est.fcns"} attribute, which is a
  named list containing the linear functions associated with each joint test.
  Each row of these is standardized to have length 1. 
  No estimable functions are included for confounded effects.

\code{make.meanint} returns the function 
\code{function(x) mean(x) + delta * c(-1, 1)},
  and \code{make.symmint(ctr, delta)} returns the function
\code{function(x) ctr + delta * c(-1, 1)}
        (which does not depend on \code{x}).
The cases with \code{delta = 1}, \code{meanint = make.meanint(1)} and
\code{symmint(ctr) = make.symmint(ctr, 1)} are retained for
back-compatibility reasons. These functions are available primarily for use
with \code{cov.reduce}.
}
\description{
This function produces an analysis-of-variance-like table based on linear
functions of predictors in a model or \code{emmGrid} object. Specifically,
the function constructs, for each combination of factors (or covariates
reduced to two or more levels), a set of (interaction) contrasts via
\code{\link{contrast}}, and then tests them using \code{\link{test}} with
\code{joint = TRUE}. Optionally, one or more of the predictors may be used as
\code{by} variable(s), so that separate tables of tests are produced for
each combination of them.
}
\details{
In models with only factors, no covariates, these tests correspond to
\dQuote{type III} tests a la \pkg{SAS}, as long as equal-weighted averaging
is used and there are no estimability issues. When covariates are present and
they interact with factors, the results depend on how the covariate is
handled in constructing the reference grid. See the section on covariates
below. The point that one must always remember is that \code{joint_tests}
always tests contrasts among EMMs, in the context of the reference grid,
whereas SAS's type III tests are tests of model coefficients -- which may or may
not have anything to do with EMMs or contrasts.
}
\note{
\code{joint_tests} is flaky with models having nested fixed effects. In
some cases, terms that could be relevant are not identified, or confounded
with unidentifiable terms.
}
\section{Dealing with covariates}{

A covariate (or any other predictor) must have \emph{more than one value in 
the reference grid} in order to test its effect and be included in the results.
Therefore, when \code{object} is a model, we default to \code{cov.reduce = meanint}
which sets each covariate at a symmetric interval about its mean. But
when \code{object} is an existing reference grid, it often has only one value 
for covariates, in which case they are excluded from the joint tests.

While having two points is sufficient when the covariate term has a linear trend,
you need more than two when some kind of curved trend (polynomial, spline, etc.)
is present -- else \code{joint_tests()} will not show enough degrees of freedom 
for terms involving the covariate. You may specify these points manually using \code{at},
or by including an \code{npts} argument in \code{cov.reduce}, via \code{make.meanint}
or \code{make.symmint()}. With some kinds of curved trends, the joint tests of
covariate terms may become somewhat meaningless.

Covariates present further complications in that their values in the
reference grid can affect the joint tests of \emph{other} effects. When
covariates are centered around their means (the default), then the tests we
obtain can be described as joint tests of covariate-adjusted means; and that
is our intended use here. However, some software such as \pkg{SAS} and
\code{car::Anova} adopt the convention of centering covariates around zero;
and for that purpose, one can use \code{cov.reduce = symmint(0)} when calling
with a model object (or in constructing a reference grid). However, adjusted
means with covariates set at or around zero do not make much sense in the
context of interpreting estimated marginal means, unless the covariate means
really are zero.

See the examples below with the \code{toy} dataset.
}

\examples{
pigs.lm <- lm(log(conc) ~ source * factor(percent), data = pigs)

(jt <- joint_tests(pigs.lm))             ## will be same as type III ANOVA

### Estimable functions associated with "percent"
attr(jt, "est.fcns") $ "percent"

joint_tests(pigs.lm, weights = "outer")  ## differently weighted

joint_tests(pigs.lm, by = "source")      ## separate joint tests of 'percent'

### Comparisons with type III tests in SAS
toy = data.frame(
    treat = rep(c("A", "B"), c(4, 6)),
    female = c(1, 0, 0, 1,   0, 0, 0, 1, 1, 0 ),
    resp = c(17, 12, 14, 19, 28, 26, 26, 34, 33, 27))
toy.fac = lm(resp ~ treat * factor(female), data = toy)
toy.cov = lm(resp ~ treat * female, data = toy)
# (These two models have identical fitted values and residuals)

# -- SAS output we'd get with toy.fac --
## Source          DF    Type III SS    Mean Square   F Value   Pr > F
## treat            1    488.8928571    488.8928571    404.60   <.0001
## female           1     78.8928571     78.8928571     65.29   0.0002
## treat*female     1      1.7500000      1.7500000      1.45   0.2741
# 
# -- SAS output we'd get with toy.cov --
## Source          DF    Type III SS    Mean Square   F Value   Pr > F
## treat            1    252.0833333    252.0833333    208.62   <.0001
## female           1     78.8928571     78.8928571     65.29   0.0002
## female*treat     1      1.7500000      1.7500000      1.45   0.2741

joint_tests(toy.fac)
joint_tests(toy.cov)   # female is regarded as a 2-level factor by default

## Treat 'female' as a numeric covariate (via cov.keep = 0)
## ... then tests depend on where we center things

# Center around the mean
joint_tests(toy.cov, cov.keep = 0, cov.reduce = make.meanint(delta = 1))
# Center around zero (like SAS's results for toy.cov)
joint_tests(toy.cov, cov.keep = 0, cov.reduce = make.symmint(ctr = 0, delta = 1))
# Center around 0.5 (like SAS's results for toy.fac)
joint_tests(toy.cov, cov.keep = 0, cov.reduce = range)

### Example with empty cells and confounded effects
low3 <- unlist(attr(ubds, "cells")[1:3]) 
ubds.lm <- lm(y ~ A*B*C, data = ubds, subset = -low3)

# Show overall joint tests by C:
ref_grid(ubds.lm, by = "C") |> contrast("consec") |> test(joint = TRUE)

# Break each of the above into smaller components:
joint_tests(ubds.lm, by = "C")

}
\seealso{
\code{\link{test}}
}
