% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-github.R
\name{chat_github}
\alias{chat_github}
\title{Chat with a model hosted on the GitHub model marketplace}
\usage{
chat_github(
  system_prompt = NULL,
  turns = NULL,
  base_url = "https://models.inference.ai.azure.com/",
  api_key = github_key(),
  model = NULL,
  seed = NULL,
  api_args = list(),
  echo = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead manage your GitHub credentials
as described in \url{https://usethis.r-lib.org/articles/git-credentials.html}.
For headless environments, this will also look in the \code{GITHUB_PAT}
env var.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
GitHub (via Azure) hosts a number of open source and OpenAI models.
To access the GitHub model marketplace, you will need to apply for and
be accepted into the beta access program. See
\url{https://github.com/marketplace/models} for details.

This function is a lightweight wrapper around \code{\link[=chat_openai]{chat_openai()}} with
the defaults tweaked for the GitHub model marketplace.
}
\examples{
\dontrun{
chat <- chat_github()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
