% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{labelled_integer}
\alias{labelled_integer}
\title{Transform a vector into consecutive integers}
\usage{
labelled_integer(x = vector())
}
\arguments{
\item{x}{A vector, which may be numeric, string, or factor.}
}
\value{
A vector of integers corresponding to entries in \code{x}.
  The lowest value will be 1, and the greatest value will equal the number of
  unique elements in \code{x}.
  The elements of the recoded vector are named according to the original
  values of \code{x}.
  The result is suitable for the \code{ii} and \code{jj} options for
  \code{\link{irt_data}}.
}
\description{
Transform a vector into consecutive integers
}
\examples{
x <- c("owl", "cat", "pony", "cat")
labelled_integer(x)

y <- as.factor(x)
labelled_integer(y)

z <- rep(c(22, 57, 13), times = 2)
labelled_integer(z)
}

