% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size_of_repetitions.R
\name{size_of_repetitions}
\alias{size_of_repetitions}
\alias{size_of_repetitions.eventlog}
\alias{size_of_repetitions.grouped_eventlog}
\title{Metric: Size of repetitions}
\usage{
size_of_repetitions(eventlog, type, level, append, ...)

\method{size_of_repetitions}{eventlog}(eventlog, type = c("all", "repeat",
  "redo"), level = c("log", "case", "activity", "resource",
  "resource-activity"), append = FALSE, ...)

\method{size_of_repetitions}{grouped_eventlog}(eventlog, type = c("repeat",
  "redo"), level = c("log", "case", "activity", "resource",
  "resource-activity"), append = FALSE, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{type}{The type of repetitions, either all, repeat or redo.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{...}{Deprecated arguments}
}
\description{
Provides summary statistics on the sizes of repetitions.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Size of repetitions for eventlog

\item \code{grouped_eventlog}: Size of repetitions for grouped event log
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{number_of_repetitions}}
}
