% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annualizer.R
\name{annualizer}
\alias{annualizer}
\title{Time-averaged restoration project outcomes}
\usage{
annualizer(timevec, benefits)
}
\arguments{
\item{timevec}{numeric vector of time intervals.}

\item{benefits}{numeric vector of values to be interpolated.}
}
\value{
A time-averaged value over the specified time horizon.
}
\description{
\code{annualizer} computes time-averaged quantities based on linear interpolation.
}
\examples{
#Constant value through time
annualizer(c(0,50), c(100,100))
annualizer(seq(0,50), rep(100,51))

#Simple time series
annualizer(seq(0,50), seq(0,50))

#User-specified time intervals
demo.timevec <- c(0,2,20,50)
demo.ben <- c(0,100,90,80)
annualizer(demo.timevec, demo.ben)

}
\references{
Robinson R., Hansen W., and Orth K. 1995. Evaluation of environmental investments
  procedures manual interim: Cost effectiveness and incremental cost analyses.
  IWR Report 95-R-1. Institute for Water Resources, U.S. Army Corps of Engineers,
  Alexandria, Virginia.
}
