% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{inv_simpson}
\alias{inv_simpson}
\title{Inverse Simpson}
\usage{
inv_simpson(counts, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A numeric vector.
}
\description{
Inverse Simpson alpha diversity metric.
}
\section{Calculation}{


Pre-transformation: drop all OTUs with zero abundance.

In the formulas below, \eqn{x} is a single column (sample) from \code{counts}.
\eqn{p} are the relative abundances.

\deqn{p_{i} = \displaystyle \frac{x_i}{\sum x}}
\deqn{D = \displaystyle 1 / \sum_{i = 1}^{n} p_{i}\times\ln(p_{i})}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)[-2]  
  p <- x / sum(x)
  1 / sum(p * log(p))
  #>  -0.7636352
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Inverse Simpson diversity values
    inv_simpson(ex_counts)
    
    # Low diversity
    inv_simpson(c(100, 1, 1, 1, 1)) # 1.08
    
    # High diversity
    inv_simpson(c(20, 20, 20, 20, 20)) # 5
    
    # Low richness
    inv_simpson(1:3) # 2.57
    
    # High richness
    inv_simpson(1:100) # 75.37
    
}
\references{
Simpson EH 1949.
Measurement of diversity.
Nature, 163.
\doi{10.1038/163688a0}
}
\seealso{
Other alpha_diversity: 
\code{\link{chao1}()},
\code{\link{faith}()},
\code{\link{shannon}()},
\code{\link{simpson}()}
}
\concept{alpha_diversity}
