% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_ebmstate.R
\name{successful_transitions}
\alias{successful_transitions}
\title{Find the unique possible path until an 
absorbing state}
\usage{
successful_transitions(unique_paths_object, to_state, tmat)
}
\arguments{
\item{unique_paths_object}{An object created by running 
\code{\link{unique_paths}}.}

\item{to_state}{An absorbing state.}

\item{tmat}{Transition matrix.}
}
\value{
A vector with the unique sequence of states between two states.
}
\description{
From a \code{unique_paths} object that
shows all possible paths until 
absorption from an initial state, 
\code{successful_transitions} picks the path
that finishes in \code{to_state}, if there is one. 
The initial state is the one defined in the 
argument \code{from_state} 
to the function \code{unique_paths}. 
The process must have a tree-like structure.
}
\details{
This function is used by \code{probtrans_by_convolution_clockforward} and \code{probtrans_by_convolution_clockreset}.
It is not meant to be called by the user.
}
\seealso{
\code{\link{unique_paths}};
\code{\link{probtrans_by_convolution_clockforward}};
\code{\link{probtrans_by_convolution_clockreset}}.
}
\author{
Rui Costa
}
