% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_and_leave_one_out.R
\name{boot_coxrfx}
\alias{boot_coxrfx}
\title{Bootstrap confidence intervals for regression coefficients}
\usage{
boot_coxrfx(
  mstate_data_expanded,
  which_group,
  min_nr_samples = 100,
  output = "CIs",
  ...
)
}
\arguments{
\item{mstate_data_expanded}{Data in `long format`, possibly with `expanded` covariates (as obtained by running mstate::expand.covs).}

\item{which_group}{A character vector with the same meaning as the `groups` argument of the function \code{CoxRFX} but named (with the covariate names).}

\item{min_nr_samples}{The confidence interval of any coefficient is based on a number of bootstrap samples at least as high as this argument. See details.}

\item{output}{Determines the sort of output. See value.}

\item{...}{Further arguments to the CoxRFX function.}
}
\value{
For each regression coefficient, the confidence intervals and the number of bootstrap samples on which they are based, if the `output` argument is equal to `CIs`; if `output` is equal to `CIs_and_coxrfx_fits`, also the \code{CoxRFX} objects for each bootstrap sample.
}
\description{
This function computes 95\% highest density bootstrap confidence intervals (non-parametric) for the regression coefficients estimated by CoxRFX.
}
\details{
In a given bootstrap sample there might not be enough information to generate 
estimates for all coefficients. If a covariate has little or no variation in a given bootstrap sample, 
no estimate of its coefficient will be computed. The present function will
keep taking bootstrap samples until every coefficient has been estimated
at least \code{min_nr_samples} times.
}
\author{
Rui Costa
}
