% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviData.R
\name{getSimpleFams}
\alias{getSimpleFams}
\title{Find the simple families of a DVI dataset}
\usage{
getSimpleFams(dvi)
}
\arguments{
\item{dvi}{A \code{dviData} object.}
}
\value{
A character (if \code{dvi$am} has names) or integer vector.
}
\description{
Extract the names (if present) or indices of the \emph{simple} reference families,
i.e., the families containing exactly 1 missing person.
}
\examples{
# No simple families
simple1 = getSimpleFams(example1)
stopifnot(length(simple1) == 0)

# Second family is simple
simple2 = getSimpleFams(example2)
stopifnot(simple2 == 2)

# With family names
simple3 = example2 |> relabelDVI(familyPrefix = "FAM") |> getSimpleFams()
stopifnot(simple3 == "FAM2")

}
\seealso{
\code{\link[=getFamily]{getFamily()}}
}
