% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPairing.R
\name{excludePairing}
\alias{excludePairing}
\title{Exclude pairings}
\usage{
excludePairing(dvi, victim, missing)
}
\arguments{
\item{dvi}{A \code{dviData} object.}

\item{victim}{The name of a single victim sample.}

\item{missing}{The name(s) of one or several missing individuals.}
}
\value{
A \code{dviData} object.
}
\description{
Disallow certain pairings by removing them from the list \code{dvi$pairings} of
candidate pairings for a given victim sample.
}
\examples{
# Disallow V1 = M1 in the `example2` dataset:
ex = excludePairing(example2, victim = "V1", missing = "M1")
jointDVI(ex, verbose = FALSE)

# Compare with original
jointDVI(example2, verbose = FALSE)

# The only difference is in the `pairings` slot:
ex$pairings
example2$pairings

}
