# Generated by 02-duckplyr_df-methods.R
#' @export
full_join.duckplyr_df <- function(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ..., keep = NULL, na_matches = c("na", "never"), multiple = "all", relationship = NULL) {
  check_dots_empty0(...)
  error_call <- caller_env()
  y <- auto_copy(x, y, copy = copy)

  # Our implementation
  rel_try(call = list(name = "full_join", x = x, y = y, args = list(by = if(!is.null(by)) as_join_by(by), copy = copy, keep = keep, na_matches = na_matches, multiple = multiple, relationship = relationship)),
    "No implicit cross joins for full_join()" = is_cross_by(by),
    {
      out <- rel_join_impl(x, y, by, "full", na_matches, suffix, keep, error_call)
      return(out)
    }
  )

  # dplyr forward
  full_join <- dplyr$full_join.data.frame
  out <- full_join(x, y, by, copy = FALSE, suffix, ..., keep = keep, na_matches = na_matches, multiple = multiple, relationship = relationship)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)
  y <- auto_copy(x, y, copy = copy)
  join_mutate(
    x = x,
    y = y,
    by = by,
    type = "full",
    suffix = suffix,
    na_matches = na_matches,
    keep = keep,
    multiple = multiple,
    # All keys from both inputs are retained. Erroring never makes sense.
    unmatched = "drop",
    relationship = relationship,
    user_env = caller_env()
  )
}

duckplyr_full_join <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df(x)
      y <- as_duckplyr_df(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- full_join(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
