% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R, R/dbBind__duckdb_result.R,
%   R/dbClearResult__duckdb_result.R, R/dbColumnInfo__duckdb_result.R,
%   R/dbFetch__duckdb_result.R, R/dbGetInfo__duckdb_result.R,
%   R/dbGetRowCount__duckdb_result.R, R/dbGetRowsAffected__duckdb_result.R,
%   R/dbGetStatement__duckdb_result.R, R/dbHasCompleted__duckdb_result.R,
%   R/dbIsValid__duckdb_result.R, R/show__duckdb_result.R
\docType{class}
\name{duckdb_result-class}
\alias{duckdb_result-class}
\alias{duckdb_result}
\alias{duckdb_fetch_arrow}
\alias{duckdb_fetch_record_batch}
\alias{dbBind__duckdb_result}
\alias{dbBind,duckdb_result-method}
\alias{dbClearResult__duckdb_result}
\alias{dbClearResult,duckdb_result-method}
\alias{dbColumnInfo__duckdb_result}
\alias{dbColumnInfo,duckdb_result-method}
\alias{dbFetch__duckdb_result}
\alias{dbFetch,duckdb_result-method}
\alias{dbGetInfo__duckdb_result}
\alias{dbGetInfo,duckdb_result-method}
\alias{dbGetRowCount__duckdb_result}
\alias{dbGetRowCount,duckdb_result-method}
\alias{dbGetRowsAffected__duckdb_result}
\alias{dbGetRowsAffected,duckdb_result-method}
\alias{dbGetStatement__duckdb_result}
\alias{dbGetStatement,duckdb_result-method}
\alias{dbHasCompleted__duckdb_result}
\alias{dbHasCompleted,duckdb_result-method}
\alias{dbIsValid__duckdb_result}
\alias{dbIsValid,duckdb_result-method}
\alias{show__duckdb_result}
\alias{show,duckdb_result-method}
\title{DuckDB Result Set}
\usage{
duckdb_fetch_arrow(res, chunk_size = 1e+06)

duckdb_fetch_record_batch(res, chunk_size = 1e+06)

\S4method{dbBind}{duckdb_result}(res, params, ...)

\S4method{dbClearResult}{duckdb_result}(res, ...)

\S4method{dbColumnInfo}{duckdb_result}(res, ...)

\S4method{dbFetch}{duckdb_result}(res, n = -1, ...)

\S4method{dbGetInfo}{duckdb_result}(dbObj, ...)

\S4method{dbGetRowCount}{duckdb_result}(res, ...)

\S4method{dbGetRowsAffected}{duckdb_result}(res, ...)

\S4method{dbGetStatement}{duckdb_result}(res, ...)

\S4method{dbHasCompleted}{duckdb_result}(res, ...)

\S4method{dbIsValid}{duckdb_result}(dbObj, ...)

\S4method{show}{duckdb_result}(object)
}
\arguments{
\item{res}{Query result to be converted to a Record Batch Reader}

\item{chunk_size}{The chunk size}

\item{params}{For \code{dbBind()}, a list of values, named or unnamed,
or a data frame, with one element/column per query parameter.
For \code{dbBindArrow()}, values as a nanoarrow stream,
with one column per query parameter.}

\item{...}{Other arguments passed on to methods.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{dbObj}{An object inheriting from class \linkS4class{duckdb_result}.}

\item{object}{Any R object}
}
\description{
Methods for accessing result sets for queries on DuckDB connections.
Implements \link[DBI:DBIResult-class]{DBI::DBIResult}.
}
\keyword{internal}
