% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SSFunctions.R
\docType{data}
\name{SSexpcons}
\alias{SSexpcons}
\title{Self-Starting Nls exponential constraint regression model}
\format{A selfStart model}
\usage{
SSexpcons(..constraint.value, x, b)
}
\arguments{
\item{..constraint.value}{a numeric value representing the value of the
response when \code{x} is 0.  In this
function this value is not a parameter is just a numeric value to
constraint \code{y_0} parameter.}

\item{x}{a numeric vector of values at which to evaluate the model}

\item{b}{a numeric parameter representing the growth rate}
}
\value{
The value returned is a list containing the nonlinear function,
the self starter function and the parameter names.
}
\description{
This selfStart model evaluates the exponential growth
regression model and its gradient. It has an \code{initial}
attribute that will evaluate initial estimates of the parameters
\code{y0}, and \code{b} for a given set of data. Instead of the standard
\code{exp} function this implementation use the \code{10^} function.
\deqn{f(x)=y_0 \times 10^b}
}
\examples{
# Load data
data(ecdata)
data(mfidata)

# Select analyte FGF for plate 1
dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)$plate_1

cons <- scluminex("plate_1",sdf$standard, sdf$background,
            lfct="SSexp",
            bkg="constraint",
            fmfi="mfi",
            verbose=FALSE)

summary(cons)

# Comparison constraint vs no constraint (same returning value but estimate
# one parameter).
b <- 3
y0 <- 1
concentration <- 2
SSexp(concentration, b, y0)
SSexpcons(y0, concentration, b)
}
\keyword{datasets}

