% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dcCA.R
\name{plot.dcca}
\alias{plot.dcca}
\title{Plot a single dc-CA axis with CWMs, SNCs, trait and environment scores.}
\usage{
\method{plot}{dcca}(
  x,
  ...,
  axis = 1,
  gradient_description = "correlation",
  envfactor = NULL,
  traitfactor = NULL,
  nspecies = 20,
  species_groups = NULL,
  widths = c(5, 1, 1),
  newnames = NULL,
  facet = TRUE,
  remove_centroids = FALSE,
  with_lines = 2,
  flip_axis = FALSE,
  expand = 0.2,
  formula = y ~ x,
  verbose = TRUE
)
}
\arguments{
\item{x}{results from \code{\link{dc_CA}} of class \code{dcca}.}

\item{...}{unused.}

\item{axis}{the axis number to get (default 1).}

\item{gradient_description}{character or 2-character vector for the trait
and environmental gradient, respectively specifying what to plot in the 
vertical line plots to describe the dc-CA axis (trait and environmental 
gradients). Default: \code{correlation} for intra-set correlations of both 
sets of variables with their dc-CA axis. Other values are: 
\code{c("weights", "tvalues", "inter_set_correlation")} for 
regression weights, t-values and inter-set correlation, 
being the correlation of the SNCs and CWMs with the traits and environmental
variables, respectively. \code{"regression"} is an alias for \code{"weights"}.}

\item{envfactor}{name of row factor to display as color and lines in the CWM
plot (default \code{NULL}). The default extracts the factor from the 
environmental model. If set to \code{NA}, no additional coloring and lines
are displayed in \code{\link{plot.dcca}}. The parameter sets the 
\code{groups} variable in the \code{CWM_SNC} data frame of the return 
value/in the plot.}

\item{traitfactor}{name of column factor to display as color and lines in
the SNC plot (default \code{NULL}). The default extracts the factor from
the trait model. If set to \code{NA}, no additional coloring and lines are
displayed in \code{\link{plot.dcca}}. The parameter sets the \code{groups} 
variable in the \code{CWM_SNC} data frame of the return value/in the plot.}

\item{nspecies}{integer. Default \code{20} for including a vertical species 
plot with at most \code{nspecies} that have the highest contribution.}

\item{species_groups}{name of a variable in \code{dataTraits} of 
\code{\link{dc_CA}}. Default \code{NULL} for no grouping. 
Species groups are colored differentially.}

\item{widths}{relative widths of the CWM-SNC plot, the correlation/weight
plot and the species plot. (see \code{\link[gridExtra]{grid.arrange}}). 
Default \code{c(5, 1, 1)}.}

\item{newnames}{a list  with two elements: names for traits and for 
environmental variables, default \code{NULL} for names derived from the 
result of \code{\link{scores.dcca}} with \code{tidy = TRUE}.}

\item{facet}{logical. Default \code{TRUE} for CWMs and SNCs plots in 
separate panels. This parameter changes the position of the centroid 
names (from left to right for the environmental centroids). If 
\code{facet = FALSE} and \code{with_lines = TRUE}, the line fits ignore 
groups of species and of sites.}

\item{remove_centroids}{logical to remove any centroids from the plot data 
(default \code{FALSE}). Can be a two-vector, \emph{e.g.} 
\code{c(TRUE, FALSE)} to remove only the trait centroids.}

\item{with_lines}{integer values (0,1,2). Default \code{2} for straight lines 
through groups of points, with confidence intervals around the lines. 
\code{with_lines=1} drops the confidence intervals and
\code{with_lines=0} suppresses the lines.}

\item{flip_axis}{flip the direction of the axis? (default FALSE).}

\item{expand}{amount of extension of the line plot (default 0.2).}

\item{formula}{formula to use by ggplot geom_smooth (default y~x).}

\item{verbose}{logical. Default \code{TRUE} for plotting the result.}
}
\value{
a ggplot object
}
\description{
\code{plot.dcca} plots the CWMs and SNCs of a dc-CA axis against this axis,
with optional centroids and colors for groups of sites and/or species if 
available in the data.
}
\details{
The current implementation does not distinguish groups of points, if there
are two or more factors specified in the model.
If you want to label one trait factor, specify 
\code{traitfactor="yourfactor"} and similarly
specify \code{envfactor="yourfactor"} for your environmental factor.

No lines are plotted if a single factor defines a model. 

If you want to set new names, look at the names with all arguments default, 
i.e. \code{myplot <- plot(x)}, and then consult 
\code{myplot$nameList$newnames} for the order of the names of traits and
environmental variables. Note that covariates should not be in the list of
names. Contribution (in the definition of species selection in 
\code{nspecies}) is defined (as in CA) as the total species abundance in 
the (possibly, closed) data multiplied by the square of the score on 
the axis.

If the \code{plot.dcca} returns the error \code{"Error in grid.Call"}, 
enlarge the plotting area or use \code{verbose = FALSE} and assign the 
result.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

# must delete "Sites" from response matrix or data frame
Y <- dune_trait_env$comm[, -1] # must delete "Sites"

out <- dc_CA(formulaEnv = ~ A1 + Moist + Use + Manure + Mag,
                   formulaTraits = ~ SLA + Height + LDMC + Seedmass + Lifespan,
                   response = Y,
                   dataEnv = dune_trait_env$envir,
                   dataTraits = dune_trait_env$traits,
                   verbose = FALSE)
dat <- getPlotdata(out)
names(dat)
names(dat$CWM_SNC)
levels(dat$CWM_SNC$groups)

plot(out)
}
